@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accessibility Indicates whether the caption track implements accessibility features such as written descriptions of spoken dialog, music, and sounds.
 * @property captionSelectorName Specifies which input caption selector to use as a caption source when generating output captions. This field should match a captionSelector name.
 * @property destinationSettings Additional settings for captions destination that depend on the destination type. See Destination Settings for more details.
 * @property languageCode ISO 639-2 three-digit code.
 * @property languageDescription Human readable information to indicate captions available for players (eg. English, or Spanish).
 * @property name Name of the caption description. Used to associate a caption description with an output. Names must be unique within an event.
 */
public data class ChannelEncoderSettingsCaptionDescription(
    public val accessibility: String? = null,
    public val captionSelectorName: String,
    public val destinationSettings: ChannelEncoderSettingsCaptionDescriptionDestinationSettings? =
        null,
    public val languageCode: String? = null,
    public val languageDescription: String? = null,
    public val name: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.ChannelEncoderSettingsCaptionDescription):
            ChannelEncoderSettingsCaptionDescription = ChannelEncoderSettingsCaptionDescription(
            accessibility = javaType.accessibility().map({ args0 -> args0 }).orElse(null),
            captionSelectorName = javaType.captionSelectorName(),
            destinationSettings = javaType.destinationSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsCaptionDescriptionDestinationSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            languageCode = javaType.languageCode().map({ args0 -> args0 }).orElse(null),
            languageDescription = javaType.languageDescription().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
        )
    }
}
