@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property copyrightHolder Complete this field if you want to include the name of the copyright holder in the copyright tag in the captions metadata.
 * @property fillLineGap Specifies how to handle the gap between the lines (in multi-line captions). - enabled: Fill with the captions background color (as specified in the input captions). - disabled: Leave the gap unfilled.
 * @property fontFamily Specifies the font family to include in the font data attached to the EBU-TT captions. Valid only if styleControl is set to include. If you leave this field empty, the font family is set to “monospaced”. (If styleControl is set to exclude, the font family is always set to “monospaced”.) You specify only the font family. All other style information (color, bold, position and so on) is copied from the input captions. The size is always set to 100% to allow the downstream player to choose the size. - Enter a list of font families, as a comma-separated list of font names, in order of preference. The name can be a font family (such as “Arial”), or a generic font family (such as “serif”), or “default” (to let the downstream player choose the font). - Leave blank to set the family to “monospace”.
 * @property styleControl Specifies the style information (font color, font position, and so on) to include in the font data that is attached to the EBU-TT captions. - include: Take the style information (font color, font position, and so on) from the source captions and include that information in the font data attached to the EBU-TT captions. This option is valid only if the source captions are Embedded or Teletext. - exclude: In the font data attached to the EBU-TT captions, set the font family to “monospaced”. Do not include any other style information.
 */
public data class
ChannelEncoderSettingsCaptionDescriptionDestinationSettingsEbuTtDDestinationSettings(
    public val copyrightHolder: String? = null,
    public val fillLineGap: String? = null,
    public val fontFamily: String? = null,
    public val styleControl: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.ChannelEncoderSettingsCaptionDescriptionDestinationSettingsEbuTtDDestinationSettings):
            ChannelEncoderSettingsCaptionDescriptionDestinationSettingsEbuTtDDestinationSettings =
            ChannelEncoderSettingsCaptionDescriptionDestinationSettingsEbuTtDDestinationSettings(
                copyrightHolder = javaType.copyrightHolder().map({ args0 -> args0 }).orElse(null),
                fillLineGap = javaType.fillLineGap().map({ args0 -> args0 }).orElse(null),
                fontFamily = javaType.fontFamily().map({ args0 -> args0 }).orElse(null),
                styleControl = javaType.styleControl().map({ args0 -> args0 }).orElse(null),
            )
    }
}
