@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property name Custom output group name defined by the user.
 * @property outputGroupSettings Settings associated with the output group. See Output Group Settings for more details.
 * @property outputs List of outputs. See Outputs for more details.
 */
public data class ChannelEncoderSettingsOutputGroup(
    public val name: String? = null,
    public val outputGroupSettings: ChannelEncoderSettingsOutputGroupOutputGroupSettings,
    public val outputs: List<ChannelEncoderSettingsOutputGroupOutput>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.ChannelEncoderSettingsOutputGroup):
            ChannelEncoderSettingsOutputGroup = ChannelEncoderSettingsOutputGroup(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            outputGroupSettings = javaType.outputGroupSettings().let({ args0 ->
                com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsOutputGroupOutputGroupSettings.Companion.toKotlin(args0)
            }),
            outputs = javaType.outputs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsOutputGroupOutput.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
