@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property audioDescriptionNames The names of the audio descriptions used as audio sources for the output.
 * @property captionDescriptionNames The names of the caption descriptions used as caption sources for the output.
 * @property outputName The name used to identify an output.
 * @property outputSettings Settings for output. See Output Settings for more details.
 * @property videoDescriptionName The name of the video description used as video source for the output.
 */
public data class ChannelEncoderSettingsOutputGroupOutput(
    public val audioDescriptionNames: List<String>? = null,
    public val captionDescriptionNames: List<String>? = null,
    public val outputName: String? = null,
    public val outputSettings: ChannelEncoderSettingsOutputGroupOutputOutputSettings,
    public val videoDescriptionName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.ChannelEncoderSettingsOutputGroupOutput):
            ChannelEncoderSettingsOutputGroupOutput = ChannelEncoderSettingsOutputGroupOutput(
            audioDescriptionNames = javaType.audioDescriptionNames().map({ args0 -> args0 }),
            captionDescriptionNames = javaType.captionDescriptionNames().map({ args0 -> args0 }),
            outputName = javaType.outputName().map({ args0 -> args0 }).orElse(null),
            outputSettings = javaType.outputSettings().let({ args0 ->
                com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsOutputGroupOutputOutputSettings.Companion.toKotlin(args0)
            }),
            videoDescriptionName = javaType.videoDescriptionName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
