@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property archiveGroupSettings Archive group settings. See Archive Group Settings for more details.
 * @property frameCaptureGroupSettings
 * @property hlsGroupSettings
 * @property mediaPackageGroupSettings Media package group settings. See Media Package Group Settings for more details.
 * @property msSmoothGroupSettings
 * @property multiplexGroupSettings
 * @property rtmpGroupSettings RTMP group settings. See RTMP Group Settings for more details.
 * @property udpGroupSettings
 */
public data class ChannelEncoderSettingsOutputGroupOutputGroupSettings(
    public val archiveGroupSettings:
    List<ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSetting>? = null,
    public val frameCaptureGroupSettings:
    ChannelEncoderSettingsOutputGroupOutputGroupSettingsFrameCaptureGroupSettings? = null,
    public val hlsGroupSettings: ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettings? =
        null,
    public val mediaPackageGroupSettings:
    ChannelEncoderSettingsOutputGroupOutputGroupSettingsMediaPackageGroupSettings? = null,
    public val msSmoothGroupSettings:
    ChannelEncoderSettingsOutputGroupOutputGroupSettingsMsSmoothGroupSettings? = null,
    public val multiplexGroupSettings:
    ChannelEncoderSettingsOutputGroupOutputGroupSettingsMultiplexGroupSettings? = null,
    public val rtmpGroupSettings:
    ChannelEncoderSettingsOutputGroupOutputGroupSettingsRtmpGroupSettings? = null,
    public val udpGroupSettings: ChannelEncoderSettingsOutputGroupOutputGroupSettingsUdpGroupSettings? =
        null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.ChannelEncoderSettingsOutputGroupOutputGroupSettings):
            ChannelEncoderSettingsOutputGroupOutputGroupSettings =
            ChannelEncoderSettingsOutputGroupOutputGroupSettings(
                archiveGroupSettings = javaType.archiveGroupSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSetting.Companion.toKotlin(args0)
                    })
                }),
                frameCaptureGroupSettings = javaType.frameCaptureGroupSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsFrameCaptureGroupSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                hlsGroupSettings = javaType.hlsGroupSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsHlsGroupSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                mediaPackageGroupSettings = javaType.mediaPackageGroupSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsMediaPackageGroupSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                msSmoothGroupSettings = javaType.msSmoothGroupSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsMsSmoothGroupSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                multiplexGroupSettings = javaType.multiplexGroupSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsMultiplexGroupSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                rtmpGroupSettings = javaType.rtmpGroupSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsRtmpGroupSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                udpGroupSettings = javaType.udpGroupSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsUdpGroupSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
