@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property acquisitionPointId
 * @property audioOnlyTimecodeControl
 * @property certificateMode Setting to allow self signed or verified RTMP certificates.
 * @property connectionRetryInterval Number of seconds to wait before retrying connection to the flash media server if the connection is lost.
 * @property destination A director and base filename where archive files should be written. See Destination for more details.
 * @property eventId
 * @property eventIdMode
 * @property eventStopBehavior
 * @property filecacheDuration
 * @property fragmentLength
 * @property inputLossAction Controls the behavior of the RTMP group if input becomes unavailable.
 * @property numRetries Number of retry attempts.
 * @property restartDelay Number of seconds to wait until a restart is initiated.
 * @property segmentationMode
 * @property sendDelayMs
 * @property sparseTrackType
 * @property streamManifestBehavior
 * @property timestampOffset
 * @property timestampOffsetMode
 */
public data class ChannelEncoderSettingsOutputGroupOutputGroupSettingsMsSmoothGroupSettings(
    public val acquisitionPointId: String? = null,
    public val audioOnlyTimecodeControl: String? = null,
    public val certificateMode: String? = null,
    public val connectionRetryInterval: Int? = null,
    public val destination:
    ChannelEncoderSettingsOutputGroupOutputGroupSettingsMsSmoothGroupSettingsDestination,
    public val eventId: String? = null,
    public val eventIdMode: String? = null,
    public val eventStopBehavior: String? = null,
    public val filecacheDuration: Int? = null,
    public val fragmentLength: Int? = null,
    public val inputLossAction: String? = null,
    public val numRetries: Int? = null,
    public val restartDelay: Int? = null,
    public val segmentationMode: String? = null,
    public val sendDelayMs: Int? = null,
    public val sparseTrackType: String? = null,
    public val streamManifestBehavior: String? = null,
    public val timestampOffset: String? = null,
    public val timestampOffsetMode: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsMsSmoothGroupSettings):
            ChannelEncoderSettingsOutputGroupOutputGroupSettingsMsSmoothGroupSettings =
            ChannelEncoderSettingsOutputGroupOutputGroupSettingsMsSmoothGroupSettings(
                acquisitionPointId = javaType.acquisitionPointId().map({ args0 -> args0 }).orElse(null),
                audioOnlyTimecodeControl = javaType.audioOnlyTimecodeControl().map({ args0 -> args0 }).orElse(null),
                certificateMode = javaType.certificateMode().map({ args0 -> args0 }).orElse(null),
                connectionRetryInterval = javaType.connectionRetryInterval().map({ args0 -> args0 }).orElse(null),
                destination = javaType.destination().let({ args0 ->
                    com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsMsSmoothGroupSettingsDestination.Companion.toKotlin(args0)
                }),
                eventId = javaType.eventId().map({ args0 -> args0 }).orElse(null),
                eventIdMode = javaType.eventIdMode().map({ args0 -> args0 }).orElse(null),
                eventStopBehavior = javaType.eventStopBehavior().map({ args0 -> args0 }).orElse(null),
                filecacheDuration = javaType.filecacheDuration().map({ args0 -> args0 }).orElse(null),
                fragmentLength = javaType.fragmentLength().map({ args0 -> args0 }).orElse(null),
                inputLossAction = javaType.inputLossAction().map({ args0 -> args0 }).orElse(null),
                numRetries = javaType.numRetries().map({ args0 -> args0 }).orElse(null),
                restartDelay = javaType.restartDelay().map({ args0 -> args0 }).orElse(null),
                segmentationMode = javaType.segmentationMode().map({ args0 -> args0 }).orElse(null),
                sendDelayMs = javaType.sendDelayMs().map({ args0 -> args0 }).orElse(null),
                sparseTrackType = javaType.sparseTrackType().map({ args0 -> args0 }).orElse(null),
                streamManifestBehavior = javaType.streamManifestBehavior().map({ args0 -> args0 }).orElse(null),
                timestampOffset = javaType.timestampOffset().map({ args0 -> args0 }).orElse(null),
                timestampOffsetMode = javaType.timestampOffsetMode().map({ args0 -> args0 }).orElse(null),
            )
    }
}
