@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property archiveOutputSettings Archive output settings. See Archive Output Settings for more details.
 * @property frameCaptureOutputSettings
 * @property hlsOutputSettings
 * @property mediaPackageOutputSettings Media package output settings. This can be set as an empty block.
 * @property msSmoothOutputSettings
 * @property multiplexOutputSettings Multiplex output settings. See Multiplex Output Settings for more details.
 * @property rtmpOutputSettings RTMP output settings. See RTMP Output Settings for more details.
 * @property udpOutputSettings UDP output settings. See UDP Output Settings for more details.
 */
public data class ChannelEncoderSettingsOutputGroupOutputOutputSettings(
    public val archiveOutputSettings:
    ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettings? = null,
    public val frameCaptureOutputSettings:
    ChannelEncoderSettingsOutputGroupOutputOutputSettingsFrameCaptureOutputSettings? = null,
    public val hlsOutputSettings:
    ChannelEncoderSettingsOutputGroupOutputOutputSettingsHlsOutputSettings? = null,
    public val mediaPackageOutputSettings:
    ChannelEncoderSettingsOutputGroupOutputOutputSettingsMediaPackageOutputSettings? = null,
    public val msSmoothOutputSettings:
    ChannelEncoderSettingsOutputGroupOutputOutputSettingsMsSmoothOutputSettings? = null,
    public val multiplexOutputSettings:
    ChannelEncoderSettingsOutputGroupOutputOutputSettingsMultiplexOutputSettings? = null,
    public val rtmpOutputSettings:
    ChannelEncoderSettingsOutputGroupOutputOutputSettingsRtmpOutputSettings? = null,
    public val udpOutputSettings:
    ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettings? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.ChannelEncoderSettingsOutputGroupOutputOutputSettings):
            ChannelEncoderSettingsOutputGroupOutputOutputSettings =
            ChannelEncoderSettingsOutputGroupOutputOutputSettings(
                archiveOutputSettings = javaType.archiveOutputSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                frameCaptureOutputSettings = javaType.frameCaptureOutputSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsFrameCaptureOutputSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                hlsOutputSettings = javaType.hlsOutputSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsHlsOutputSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                mediaPackageOutputSettings = javaType.mediaPackageOutputSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsMediaPackageOutputSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                msSmoothOutputSettings = javaType.msSmoothOutputSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsMsSmoothOutputSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                multiplexOutputSettings = javaType.multiplexOutputSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsMultiplexOutputSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                rtmpOutputSettings = javaType.rtmpOutputSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsRtmpOutputSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                udpOutputSettings = javaType.udpOutputSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
