@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property containerSettings Settings specific to the container type of the file. See Container Settings for more details.
 * @property extension Output file extension.
 * @property nameModifier String concatenated to the end of the destination filename. Required for multiple outputs of the same type.
 */
public data class ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettings(
    public val containerSettings:
    ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsContainerSettings? =
        null,
    public val extension: String? = null,
    public val nameModifier: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettings):
            ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettings =
            ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettings(
                containerSettings = javaType.containerSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsContainerSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                extension = javaType.extension().map({ args0 -> args0 }).orElse(null),
                nameModifier = javaType.nameModifier().map({ args0 -> args0 }).orElse(null),
            )
    }
}
