@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property bufferMsec UDP output buffering in milliseconds.
 * @property containerSettings UDP container settings. See Container Settings for more details.
 * @property destination Destination address and port number for RTP or UDP packets. See Destination for more details.
 * @property fecOutputSettings
 */
public data class ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettings(
    public val bufferMsec: Int? = null,
    public val containerSettings:
    ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsContainerSettings,
    public val destination:
    ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsDestination,
    public val fecOutputSettings:
    ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsFecOutputSettings? =
        null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettings):
            ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettings =
            ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettings(
                bufferMsec = javaType.bufferMsec().map({ args0 -> args0 }).orElse(null),
                containerSettings = javaType.containerSettings().let({ args0 ->
                    com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsContainerSettings.Companion.toKotlin(args0)
                }),
                destination = javaType.destination().let({ args0 ->
                    com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsDestination.Companion.toKotlin(args0)
                }),
                fecOutputSettings = javaType.fecOutputSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsFecOutputSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
