@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property columnDepth The height of the FEC protection matrix.
 * @property includeFec Enables column only or column and row based FEC.
 * @property rowLength The width of the FEC protection matrix.
 */
public data class
ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsFecOutputSettings(
    public val columnDepth: Int? = null,
    public val includeFec: String? = null,
    public val rowLength: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsFecOutputSettings):
            ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsFecOutputSettings =
            ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsFecOutputSettings(
                columnDepth = javaType.columnDepth().map({ args0 -> args0 }).orElse(null),
                includeFec = javaType.includeFec().map({ args0 -> args0 }).orElse(null),
                rowLength = javaType.rowLength().map({ args0 -> args0 }).orElse(null),
            )
    }
}
