@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property codecSettings The video codec settings. See Video Codec Settings for more details.
 * @property height Output video height in pixels.
 * @property name The name of the video description.
 * @property respondToAfd Indicate how to respond to the AFD values that might be in the input video.
 * @property scalingBehavior Behavior on how to scale.
 * @property sharpness Changes the strength of the anti-alias filter used for scaling.
 * @property width Output video width in pixels.
 */
public data class ChannelEncoderSettingsVideoDescription(
    public val codecSettings: ChannelEncoderSettingsVideoDescriptionCodecSettings? = null,
    public val height: Int? = null,
    public val name: String,
    public val respondToAfd: String? = null,
    public val scalingBehavior: String? = null,
    public val sharpness: Int? = null,
    public val width: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.ChannelEncoderSettingsVideoDescription):
            ChannelEncoderSettingsVideoDescription = ChannelEncoderSettingsVideoDescription(
            codecSettings = javaType.codecSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsVideoDescriptionCodecSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            height = javaType.height().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            respondToAfd = javaType.respondToAfd().map({ args0 -> args0 }).orElse(null),
            scalingBehavior = javaType.scalingBehavior().map({ args0 -> args0 }).orElse(null),
            sharpness = javaType.sharpness().map({ args0 -> args0 }).orElse(null),
            width = javaType.width().map({ args0 -> args0 }).orElse(null),
        )
    }
}
