@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property errorClearTimeMsec This clear time defines the requirement a recovered input must meet to be considered healthy. The input must have no failover conditions for this length of time. Enter a time in milliseconds. This value is particularly important if the input\_preference for the failover pair is set to PRIMARY\_INPUT\_PREFERRED, because after this time, MediaLive will switch back to the primary input.
 * @property failoverConditions
 * @property inputPreference Input preference when deciding which input to make active when a previously failed input has recovered.
 * @property secondaryInputId The input ID of the secondary input in the automatic input failover pair.
 */
public data class ChannelInputAttachmentAutomaticInputFailoverSettings(
    public val errorClearTimeMsec: Int? = null,
    public val failoverConditions:
    List<ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverCondition>? = null,
    public val inputPreference: String? = null,
    public val secondaryInputId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.ChannelInputAttachmentAutomaticInputFailoverSettings):
            ChannelInputAttachmentAutomaticInputFailoverSettings =
            ChannelInputAttachmentAutomaticInputFailoverSettings(
                errorClearTimeMsec = javaType.errorClearTimeMsec().map({ args0 -> args0 }).orElse(null),
                failoverConditions = javaType.failoverConditions().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverCondition.Companion.toKotlin(args0)
                    })
                }),
                inputPreference = javaType.inputPreference().map({ args0 -> args0 }).orElse(null),
                secondaryInputId = javaType.secondaryInputId(),
            )
    }
}
