@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property audioSelectors
 * @property captionSelectors
 * @property deblockFilter Enable or disable the deblock filter when filtering.
 * @property denoiseFilter Enable or disable the denoise filter when filtering.
 * @property filterStrength Adjusts the magnitude of filtering from 1 (minimal) to 5 (strongest).
 * @property inputFilter Turns on the filter for the input.
 * @property networkInputSettings Input settings. See Network Input Settings for more details.
 * @property scte35Pid PID from which to read SCTE-35 messages.
 * @property smpte2038DataPreference Specifies whether to extract applicable ancillary data from a SMPTE-2038 source in the input.
 * @property sourceEndBehavior Loop input if it is a file.
 * @property videoSelector
 */
public data class ChannelInputAttachmentInputSettings(
    public val audioSelectors: List<ChannelInputAttachmentInputSettingsAudioSelector>? = null,
    public val captionSelectors: List<ChannelInputAttachmentInputSettingsCaptionSelector>? = null,
    public val deblockFilter: String? = null,
    public val denoiseFilter: String? = null,
    public val filterStrength: Int? = null,
    public val inputFilter: String? = null,
    public val networkInputSettings: ChannelInputAttachmentInputSettingsNetworkInputSettings? = null,
    public val scte35Pid: Int? = null,
    public val smpte2038DataPreference: String? = null,
    public val sourceEndBehavior: String? = null,
    public val videoSelector: ChannelInputAttachmentInputSettingsVideoSelector? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.ChannelInputAttachmentInputSettings):
            ChannelInputAttachmentInputSettings = ChannelInputAttachmentInputSettings(
            audioSelectors = javaType.audioSelectors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.medialive.kotlin.outputs.ChannelInputAttachmentInputSettingsAudioSelector.Companion.toKotlin(args0)
                })
            }),
            captionSelectors = javaType.captionSelectors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.medialive.kotlin.outputs.ChannelInputAttachmentInputSettingsCaptionSelector.Companion.toKotlin(args0)
                })
            }),
            deblockFilter = javaType.deblockFilter().map({ args0 -> args0 }).orElse(null),
            denoiseFilter = javaType.denoiseFilter().map({ args0 -> args0 }).orElse(null),
            filterStrength = javaType.filterStrength().map({ args0 -> args0 }).orElse(null),
            inputFilter = javaType.inputFilter().map({ args0 -> args0 }).orElse(null),
            networkInputSettings = javaType.networkInputSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.medialive.kotlin.outputs.ChannelInputAttachmentInputSettingsNetworkInputSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            scte35Pid = javaType.scte35Pid().map({ args0 -> args0 }).orElse(null),
            smpte2038DataPreference = javaType.smpte2038DataPreference().map({ args0 -> args0 }).orElse(null),
            sourceEndBehavior = javaType.sourceEndBehavior().map({ args0 -> args0 }).orElse(null),
            videoSelector = javaType.videoSelector().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.medialive.kotlin.outputs.ChannelInputAttachmentInputSettingsVideoSelector.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
