@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property languageCode Selects a specific three-letter language code from within an audio source.
 * @property languageSelectionPolicy When set to “strict”, the transport stream demux strictly identifies audio streams by their language descriptor. If a PMT update occurs such that an audio stream matching the initially selected language is no longer present then mute will be encoded until the language returns. If “loose”, then on a PMT update the demux will choose another audio stream in the program with the same stream type if it can’t find one with the same language.
 */
public data class
ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioLanguageSelection(
    public val languageCode: String,
    public val languageSelectionPolicy: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioLanguageSelection):
            ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioLanguageSelection =
            ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioLanguageSelection(
                languageCode = javaType.languageCode(),
                languageSelectionPolicy = javaType.languageSelectionPolicy().map({ args0 -> args0 }).orElse(null),
            )
    }
}
