@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property convert608To708 If upconvert, 608 data is both passed through via the “608 compatibility bytes” fields of the 708 wrapper as well as translated into 708. 708 data present in the source content will be discarded.
 * @property source608ChannelNumber Specifies the 608/708 channel number within the video track from which to extract captions. Unused for passthrough.
 */
public data class
ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsScte20SourceSettings(
    public val convert608To708: String? = null,
    public val source608ChannelNumber: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsScte20SourceSettings):
            ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsScte20SourceSettings =
            ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsScte20SourceSettings(
                convert608To708 = javaType.convert608To708().map({ args0 -> args0 }).orElse(null),
                source608ChannelNumber = javaType.source608ChannelNumber().map({ args0 -> args0 }).orElse(null),
            )
    }
}
