@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property availabilityZones
 * @property networkInterfaceIds
 * @property publicAddressAllocationIds List of public address allocation ids to associate with ENIs that will be created in Output VPC. Must specify one for SINGLE_PIPELINE, two for STANDARD channels.
 * @property securityGroupIds A list of up to 5 EC2 VPC security group IDs to attach to the Output VPC network interfaces. If none are specified then the VPC default security group will be used.
 * @property subnetIds A list of VPC subnet IDs from the same VPC. If STANDARD channel, subnet IDs must be mapped to two unique availability zones (AZ).
 */
public data class ChannelVpc(
    public val availabilityZones: List<String>? = null,
    public val networkInterfaceIds: List<String>? = null,
    public val publicAddressAllocationIds: List<String>,
    public val securityGroupIds: List<String>? = null,
    public val subnetIds: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.ChannelVpc): ChannelVpc =
            ChannelVpc(
                availabilityZones = javaType.availabilityZones().map({ args0 -> args0 }),
                networkInterfaceIds = javaType.networkInterfaceIds().map({ args0 -> args0 }),
                publicAddressAllocationIds = javaType.publicAddressAllocationIds().map({ args0 -> args0 }),
                securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
                subnetIds = javaType.subnetIds().map({ args0 -> args0 }),
            )
    }
}
