@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property passwordParam The key used to extract the password from EC2 Parameter store.
 * @property url The URL where the stream is pulled from.
 * @property username The username for the input source.
 */
public data class InputSource(
    public val passwordParam: String,
    public val url: String,
    public val username: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.InputSource): InputSource =
            InputSource(
                passwordParam = javaType.passwordParam(),
                url = javaType.url(),
                username = javaType.username(),
            )
    }
}
