@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property maximumVideoBufferDelayMilliseconds Maximum video buffer delay.
 * @property transportStreamBitrate Transport stream bit rate.
 * @property transportStreamId Unique ID for each multiplex.
 * @property transportStreamReservedBitrate Transport stream reserved bit rate.
 */
public data class MultiplexMultiplexSettings(
    public val maximumVideoBufferDelayMilliseconds: Int? = null,
    public val transportStreamBitrate: Int,
    public val transportStreamId: Int,
    public val transportStreamReservedBitrate: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.MultiplexMultiplexSettings):
            MultiplexMultiplexSettings = MultiplexMultiplexSettings(
            maximumVideoBufferDelayMilliseconds = javaType.maximumVideoBufferDelayMilliseconds().map({ args0 ->
                args0
            }).orElse(null),
            transportStreamBitrate = javaType.transportStreamBitrate(),
            transportStreamId = javaType.transportStreamId(),
            transportStreamReservedBitrate = javaType.transportStreamReservedBitrate().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
