@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property preferredChannelPipeline Enum for preferred channel pipeline. Options are `CURRENTLY_ACTIVE`, `PIPELINE_0`, or `PIPELINE_1`.
 * @property programNumber Unique program number.
 * @property serviceDescriptor Service Descriptor. See Service Descriptor for more details.
 * @property videoSettings Video settings. See Video Settings for more details.
 */
public data class MultiplexProgramMultiplexProgramSettings(
    public val preferredChannelPipeline: String,
    public val programNumber: Int,
    public val serviceDescriptor: MultiplexProgramMultiplexProgramSettingsServiceDescriptor? = null,
    public val videoSettings: MultiplexProgramMultiplexProgramSettingsVideoSettings? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.MultiplexProgramMultiplexProgramSettings):
            MultiplexProgramMultiplexProgramSettings = MultiplexProgramMultiplexProgramSettings(
            preferredChannelPipeline = javaType.preferredChannelPipeline(),
            programNumber = javaType.programNumber(),
            serviceDescriptor = javaType.serviceDescriptor().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.medialive.kotlin.outputs.MultiplexProgramMultiplexProgramSettingsServiceDescriptor.Companion.toKotlin(args0)
                })
            }).orElse(null),
            videoSettings = javaType.videoSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.medialive.kotlin.outputs.MultiplexProgramMultiplexProgramSettingsVideoSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
