@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mediastore.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ContainerPolicy].
 */
@PulumiTagMarker
public class ContainerPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ContainerPolicyArgs = ContainerPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ContainerPolicyArgsBuilder.() -> Unit) {
        val builder = ContainerPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ContainerPolicy {
        val builtJavaResource = com.pulumi.aws.mediastore.ContainerPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ContainerPolicy(builtJavaResource)
    }
}

/**
 * Provides a MediaStore Container Policy.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.mediastore.Container;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.mediastore.ContainerPolicy;
 * import com.pulumi.aws.mediastore.ContainerPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var currentRegion = AwsFunctions.getRegion();
 *         final var currentCallerIdentity = AwsFunctions.getCallerIdentity();
 *         var exampleContainer = new Container("exampleContainer");
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("MediaStoreFullAccess")
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers(String.format("arn:aws:iam::%s:root", currentCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId())))
 *                     .build())
 *                 .actions("mediastore:*")
 *                 .resources(exampleContainer.name().applyValue(name -> String.format("arn:aws:mediastore:%s:%s:container/%s/*", currentRegion.applyValue(getRegionResult -> getRegionResult.name()),currentCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()),name)))
 *                 .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                     .test("Bool")
 *                     .variable("aws:SecureTransport")
 *                     .values("true")
 *                     .build())
 *                 .build())
 *             .build());
 *         var exampleContainerPolicy = new ContainerPolicy("exampleContainerPolicy", ContainerPolicyArgs.builder()
 *             .containerName(exampleContainer.name())
 *             .policy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(examplePolicyDocument -> examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import MediaStore Container Policy using the MediaStore Container Name. For example:
 * ```sh
 *  $ pulumi import aws:mediastore/containerPolicy:ContainerPolicy example example
 * ```
 * */
 */
public class ContainerPolicy internal constructor(
    override val javaResource: com.pulumi.aws.mediastore.ContainerPolicy,
) : KotlinCustomResource(javaResource, ContainerPolicyMapper) {
    /**
     * The name of the container.
     */
    public val containerName: Output<String>
        get() = javaResource.containerName().applyValue({ args0 -> args0 })

    /**
     * The contents of the policy.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })
}

public object ContainerPolicyMapper : ResourceMapper<ContainerPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.mediastore.ContainerPolicy::class == javaResource::class

    override fun map(javaResource: Resource): ContainerPolicy = ContainerPolicy(
        javaResource as
            com.pulumi.aws.mediastore.ContainerPolicy,
    )
}

/**
 * @see [ContainerPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ContainerPolicy].
 */
public suspend fun containerPolicy(
    name: String,
    block: suspend ContainerPolicyResourceBuilder.() -> Unit,
): ContainerPolicy {
    val builder = ContainerPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ContainerPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun containerPolicy(name: String): ContainerPolicy {
    val builder = ContainerPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
