@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mediastore.kotlin

import com.pulumi.aws.mediastore.ContainerPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a MediaStore Container Policy.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.mediastore.Container;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.mediastore.ContainerPolicy;
 * import com.pulumi.aws.mediastore.ContainerPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var currentRegion = AwsFunctions.getRegion();
 *         final var currentCallerIdentity = AwsFunctions.getCallerIdentity();
 *         var exampleContainer = new Container("exampleContainer");
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("MediaStoreFullAccess")
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers(String.format("arn:aws:iam::%s:root", currentCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId())))
 *                     .build())
 *                 .actions("mediastore:*")
 *                 .resources(exampleContainer.name().applyValue(name -> String.format("arn:aws:mediastore:%s:%s:container/%s/*", currentRegion.applyValue(getRegionResult -> getRegionResult.name()),currentCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()),name)))
 *                 .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                     .test("Bool")
 *                     .variable("aws:SecureTransport")
 *                     .values("true")
 *                     .build())
 *                 .build())
 *             .build());
 *         var exampleContainerPolicy = new ContainerPolicy("exampleContainerPolicy", ContainerPolicyArgs.builder()
 *             .containerName(exampleContainer.name())
 *             .policy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(examplePolicyDocument -> examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import MediaStore Container Policy using the MediaStore Container Name. For example:
 * ```sh
 *  $ pulumi import aws:mediastore/containerPolicy:ContainerPolicy example example
 * ```
 * @property containerName The name of the container.
 * @property policy The contents of the policy.
 * */
 */
public data class ContainerPolicyArgs(
    public val containerName: Output<String>? = null,
    public val policy: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.mediastore.ContainerPolicyArgs> {
    override fun toJava(): com.pulumi.aws.mediastore.ContainerPolicyArgs =
        com.pulumi.aws.mediastore.ContainerPolicyArgs.builder()
            .containerName(containerName?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerPolicyArgs].
 */
@PulumiTagMarker
public class ContainerPolicyArgsBuilder internal constructor() {
    private var containerName: Output<String>? = null

    private var policy: Output<String>? = null

    /**
     * @param value The name of the container.
     */
    @JvmName("vlxbdbafbfcncmuc")
    public suspend fun containerName(`value`: Output<String>) {
        this.containerName = value
    }

    /**
     * @param value The contents of the policy.
     */
    @JvmName("fbwvhofvutimjceo")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value The name of the container.
     */
    @JvmName("wcvmnwknwgotagfn")
    public suspend fun containerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerName = mapped
    }

    /**
     * @param value The contents of the policy.
     */
    @JvmName("anekiueqokjbdavy")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    internal fun build(): ContainerPolicyArgs = ContainerPolicyArgs(
        containerName = containerName,
        policy = policy,
    )
}
