@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.memorydb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Acl].
 */
@PulumiTagMarker
public class AclResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AclArgs = AclArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AclArgsBuilder.() -> Unit) {
        val builder = AclArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Acl {
        val builtJavaResource = com.pulumi.aws.memorydb.Acl(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Acl(builtJavaResource)
    }
}

/**
 * Provides a MemoryDB ACL.
 * More information about users and ACL-s can be found in the [MemoryDB User Guide](https://docs.aws.amazon.com/memorydb/latest/devguide/clusters.acls.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.memorydb.Acl;
 * import com.pulumi.aws.memorydb.AclArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Acl("example", AclArgs.builder()
 *             .userNames(
 *                 "my-user-1",
 *                 "my-user-2")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import an ACL using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:memorydb/acl:Acl example my-acl
 * ```
 *
 */
public class Acl internal constructor(
    override val javaResource: com.pulumi.aws.memorydb.Acl,
) : KotlinCustomResource(javaResource, AclMapper) {
    /**
     * The ARN of the ACL.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The minimum engine version supported by the ACL.
     */
    public val minimumEngineVersion: Output<String>
        get() = javaResource.minimumEngineVersion().applyValue({ args0 -> args0 })

    /**
     * Name of the ACL. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Set of MemoryDB user names to be included in this ACL.
     */
    public val userNames: Output<List<String>>?
        get() = javaResource.userNames().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object AclMapper : ResourceMapper<Acl> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.memorydb.Acl::class == javaResource::class

    override fun map(javaResource: Resource): Acl = Acl(javaResource as com.pulumi.aws.memorydb.Acl)
}

/**
 * @see [Acl].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Acl].
 */
public suspend fun acl(name: String, block: suspend AclResourceBuilder.() -> Unit): Acl {
    val builder = AclResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Acl].
 * @param name The _unique_ name of the resulting resource.
 */
public fun acl(name: String): Acl {
    val builder = AclResourceBuilder()
    builder.name(name)
    return builder.build()
}
