@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.memorydb.kotlin

import com.pulumi.aws.memorydb.ClusterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a MemoryDB Cluster.
 * More information about MemoryDB can be found in the [Developer Guide](https://docs.aws.amazon.com/memorydb/latest/devguide/what-is-memorydb-for-redis.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.memorydb.Cluster;
 * import com.pulumi.aws.memorydb.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Cluster("example", ClusterArgs.builder()
 *             .aclName("open-access")
 *             .nodeType("db.t4g.small")
 *             .numShards(2)
 *             .securityGroupIds(aws_security_group.example().id())
 *             .snapshotRetentionLimit(7)
 *             .subnetGroupName(aws_memorydb_subnet_group.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import a cluster using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:memorydb/cluster:Cluster example my-cluster
 * ```
 * @property aclName The name of the Access Control List to associate with the cluster.
 * @property autoMinorVersionUpgrade When set to `true`, the cluster will automatically receive minor engine version upgrades after launch. Defaults to `true`.
 * @property dataTiering Enables data tiering. This option is not supported by all instance types. For more information, see [Data tiering](https://docs.aws.amazon.com/memorydb/latest/devguide/data-tiering.html).
 * @property description Description for the cluster.
 * @property engineVersion Version number of the Redis engine to be used for the cluster. Downgrades are not supported.
 * @property finalSnapshotName Name of the final cluster snapshot to be created when this resource is deleted. If omitted, no final snapshot will be made.
 * @property kmsKeyArn ARN of the KMS key used to encrypt the cluster at rest.
 * @property maintenanceWindow Specifies the weekly time range during which maintenance on the cluster is performed. Specify as a range in the format `ddd:hh24:mi-ddd:hh24:mi` (24H Clock UTC). The minimum maintenance window is a 60 minute period. Example: `sun:23:00-mon:01:30`.
 * @property name Name of the cluster. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
 * @property namePrefix Creates a unique name beginning with the specified prefix. Conflicts with `name`.
 * @property nodeType The compute and memory capacity of the nodes in the cluster. See AWS documentation on [supported node types](https://docs&#46;aws&#46;amazon&#46;com/memorydb/latest/devguide/nodes&#46;supportedtypes&#46;html) as well as [vertical scaling](https://docs.aws.amazon.com/memorydb/latest/devguide/cluster-vertical-scaling.html).
 * The following arguments are optional:
 * @property numReplicasPerShard The number of replicas to apply to each shard, up to a maximum of 5. Defaults to `1` (i.e. 2 nodes per shard).
 * @property numShards The number of shards in the cluster. Defaults to `1`.
 * @property parameterGroupName The name of the parameter group associated with the cluster.
 * @property port The port number on which each of the nodes accepts connections. Defaults to `6379`.
 * @property securityGroupIds Set of VPC Security Group ID-s to associate with this cluster.
 * @property snapshotArns List of ARN-s that uniquely identify RDB snapshot files stored in S3. The snapshot files will be used to populate the new cluster. Object names in the ARN-s cannot contain any commas.
 * @property snapshotName The name of a snapshot from which to restore data into the new cluster.
 * @property snapshotRetentionLimit The number of days for which MemoryDB retains automatic snapshots before deleting them. When set to `0`, automatic backups are disabled. Defaults to `0`.
 * @property snapshotWindow The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your shard. Example: `05:00-09:00`.
 * @property snsTopicArn ARN of the SNS topic to which cluster notifications are sent.
 * @property subnetGroupName The name of the subnet group to be used for the cluster. Defaults to a subnet group consisting of default VPC subnets.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property tlsEnabled A flag to enable in-transit encryption on the cluster. When set to `false`, the `acl_name` must be `open-access`. Defaults to `true`.
 */
public data class ClusterArgs(
    public val aclName: Output<String>? = null,
    public val autoMinorVersionUpgrade: Output<Boolean>? = null,
    public val dataTiering: Output<Boolean>? = null,
    public val description: Output<String>? = null,
    public val engineVersion: Output<String>? = null,
    public val finalSnapshotName: Output<String>? = null,
    public val kmsKeyArn: Output<String>? = null,
    public val maintenanceWindow: Output<String>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val nodeType: Output<String>? = null,
    public val numReplicasPerShard: Output<Int>? = null,
    public val numShards: Output<Int>? = null,
    public val parameterGroupName: Output<String>? = null,
    public val port: Output<Int>? = null,
    public val securityGroupIds: Output<List<String>>? = null,
    public val snapshotArns: Output<List<String>>? = null,
    public val snapshotName: Output<String>? = null,
    public val snapshotRetentionLimit: Output<Int>? = null,
    public val snapshotWindow: Output<String>? = null,
    public val snsTopicArn: Output<String>? = null,
    public val subnetGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val tlsEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.memorydb.ClusterArgs> {
    override fun toJava(): com.pulumi.aws.memorydb.ClusterArgs =
        com.pulumi.aws.memorydb.ClusterArgs.builder()
            .aclName(aclName?.applyValue({ args0 -> args0 }))
            .autoMinorVersionUpgrade(autoMinorVersionUpgrade?.applyValue({ args0 -> args0 }))
            .dataTiering(dataTiering?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .engineVersion(engineVersion?.applyValue({ args0 -> args0 }))
            .finalSnapshotName(finalSnapshotName?.applyValue({ args0 -> args0 }))
            .kmsKeyArn(kmsKeyArn?.applyValue({ args0 -> args0 }))
            .maintenanceWindow(maintenanceWindow?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .nodeType(nodeType?.applyValue({ args0 -> args0 }))
            .numReplicasPerShard(numReplicasPerShard?.applyValue({ args0 -> args0 }))
            .numShards(numShards?.applyValue({ args0 -> args0 }))
            .parameterGroupName(parameterGroupName?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .snapshotArns(snapshotArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .snapshotName(snapshotName?.applyValue({ args0 -> args0 }))
            .snapshotRetentionLimit(snapshotRetentionLimit?.applyValue({ args0 -> args0 }))
            .snapshotWindow(snapshotWindow?.applyValue({ args0 -> args0 }))
            .snsTopicArn(snsTopicArn?.applyValue({ args0 -> args0 }))
            .subnetGroupName(subnetGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .tlsEnabled(tlsEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterArgs].
 */
@PulumiTagMarker
public class ClusterArgsBuilder internal constructor() {
    private var aclName: Output<String>? = null

    private var autoMinorVersionUpgrade: Output<Boolean>? = null

    private var dataTiering: Output<Boolean>? = null

    private var description: Output<String>? = null

    private var engineVersion: Output<String>? = null

    private var finalSnapshotName: Output<String>? = null

    private var kmsKeyArn: Output<String>? = null

    private var maintenanceWindow: Output<String>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var nodeType: Output<String>? = null

    private var numReplicasPerShard: Output<Int>? = null

    private var numShards: Output<Int>? = null

    private var parameterGroupName: Output<String>? = null

    private var port: Output<Int>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var snapshotArns: Output<List<String>>? = null

    private var snapshotName: Output<String>? = null

    private var snapshotRetentionLimit: Output<Int>? = null

    private var snapshotWindow: Output<String>? = null

    private var snsTopicArn: Output<String>? = null

    private var subnetGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var tlsEnabled: Output<Boolean>? = null

    /**
     * @param value The name of the Access Control List to associate with the cluster.
     */
    @JvmName("jnmuguikhiwwagfx")
    public suspend fun aclName(`value`: Output<String>) {
        this.aclName = value
    }

    /**
     * @param value When set to `true`, the cluster will automatically receive minor engine version upgrades after launch. Defaults to `true`.
     */
    @JvmName("xlpiwiyqjchrrhby")
    public suspend fun autoMinorVersionUpgrade(`value`: Output<Boolean>) {
        this.autoMinorVersionUpgrade = value
    }

    /**
     * @param value Enables data tiering. This option is not supported by all instance types. For more information, see [Data tiering](https://docs.aws.amazon.com/memorydb/latest/devguide/data-tiering.html).
     */
    @JvmName("euxfbefnpjshholi")
    public suspend fun dataTiering(`value`: Output<Boolean>) {
        this.dataTiering = value
    }

    /**
     * @param value Description for the cluster.
     */
    @JvmName("maatckhqexjenmkt")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Version number of the Redis engine to be used for the cluster. Downgrades are not supported.
     */
    @JvmName("ovfaojvndwdguuok")
    public suspend fun engineVersion(`value`: Output<String>) {
        this.engineVersion = value
    }

    /**
     * @param value Name of the final cluster snapshot to be created when this resource is deleted. If omitted, no final snapshot will be made.
     */
    @JvmName("jhoknfpeunoojghf")
    public suspend fun finalSnapshotName(`value`: Output<String>) {
        this.finalSnapshotName = value
    }

    /**
     * @param value ARN of the KMS key used to encrypt the cluster at rest.
     */
    @JvmName("pptlsxlfuljmaipq")
    public suspend fun kmsKeyArn(`value`: Output<String>) {
        this.kmsKeyArn = value
    }

    /**
     * @param value Specifies the weekly time range during which maintenance on the cluster is performed. Specify as a range in the format `ddd:hh24:mi-ddd:hh24:mi` (24H Clock UTC). The minimum maintenance window is a 60 minute period. Example: `sun:23:00-mon:01:30`.
     */
    @JvmName("svqrlybjtsyreltr")
    public suspend fun maintenanceWindow(`value`: Output<String>) {
        this.maintenanceWindow = value
    }

    /**
     * @param value Name of the cluster. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    @JvmName("aasjkujmoxbeayxo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("yyykdguibkwqslqp")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value The compute and memory capacity of the nodes in the cluster. See AWS documentation on [supported node types](https://docs&#46;aws&#46;amazon&#46;com/memorydb/latest/devguide/nodes&#46;supportedtypes&#46;html) as well as [vertical scaling](https://docs.aws.amazon.com/memorydb/latest/devguide/cluster-vertical-scaling.html).
     * The following arguments are optional:
     */
    @JvmName("kygfiopmsagcbngp")
    public suspend fun nodeType(`value`: Output<String>) {
        this.nodeType = value
    }

    /**
     * @param value The number of replicas to apply to each shard, up to a maximum of 5. Defaults to `1` (i.e. 2 nodes per shard).
     */
    @JvmName("vhwkulvmgwfdwtpx")
    public suspend fun numReplicasPerShard(`value`: Output<Int>) {
        this.numReplicasPerShard = value
    }

    /**
     * @param value The number of shards in the cluster. Defaults to `1`.
     */
    @JvmName("ewslfcqjtcbblyeq")
    public suspend fun numShards(`value`: Output<Int>) {
        this.numShards = value
    }

    /**
     * @param value The name of the parameter group associated with the cluster.
     */
    @JvmName("baafxsmmeusapopo")
    public suspend fun parameterGroupName(`value`: Output<String>) {
        this.parameterGroupName = value
    }

    /**
     * @param value The port number on which each of the nodes accepts connections. Defaults to `6379`.
     */
    @JvmName("ogwvsqdphaevsgsu")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value Set of VPC Security Group ID-s to associate with this cluster.
     */
    @JvmName("wtpvwjalguqkojbp")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("rvltvvsdjttdmffd")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values Set of VPC Security Group ID-s to associate with this cluster.
     */
    @JvmName("xxugqhgldyddmjak")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value List of ARN-s that uniquely identify RDB snapshot files stored in S3. The snapshot files will be used to populate the new cluster. Object names in the ARN-s cannot contain any commas.
     */
    @JvmName("tbynopcmsowfsthe")
    public suspend fun snapshotArns(`value`: Output<List<String>>) {
        this.snapshotArns = value
    }

    @JvmName("pfboajsmgucdfixm")
    public suspend fun snapshotArns(vararg values: Output<String>) {
        this.snapshotArns = Output.all(values.asList())
    }

    /**
     * @param values List of ARN-s that uniquely identify RDB snapshot files stored in S3. The snapshot files will be used to populate the new cluster. Object names in the ARN-s cannot contain any commas.
     */
    @JvmName("iotlvcmsxwtvsevd")
    public suspend fun snapshotArns(values: List<Output<String>>) {
        this.snapshotArns = Output.all(values)
    }

    /**
     * @param value The name of a snapshot from which to restore data into the new cluster.
     */
    @JvmName("gvieqhyuwneflexs")
    public suspend fun snapshotName(`value`: Output<String>) {
        this.snapshotName = value
    }

    /**
     * @param value The number of days for which MemoryDB retains automatic snapshots before deleting them. When set to `0`, automatic backups are disabled. Defaults to `0`.
     */
    @JvmName("ixjawmuwghevlwbi")
    public suspend fun snapshotRetentionLimit(`value`: Output<Int>) {
        this.snapshotRetentionLimit = value
    }

    /**
     * @param value The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your shard. Example: `05:00-09:00`.
     */
    @JvmName("ybyrrfrgpragtogi")
    public suspend fun snapshotWindow(`value`: Output<String>) {
        this.snapshotWindow = value
    }

    /**
     * @param value ARN of the SNS topic to which cluster notifications are sent.
     */
    @JvmName("oypgqhqmndecypro")
    public suspend fun snsTopicArn(`value`: Output<String>) {
        this.snsTopicArn = value
    }

    /**
     * @param value The name of the subnet group to be used for the cluster. Defaults to a subnet group consisting of default VPC subnets.
     */
    @JvmName("eileakmvtncmdibd")
    public suspend fun subnetGroupName(`value`: Output<String>) {
        this.subnetGroupName = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gweouabfqwccqvve")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A flag to enable in-transit encryption on the cluster. When set to `false`, the `acl_name` must be `open-access`. Defaults to `true`.
     */
    @JvmName("wdwntddyicajvecy")
    public suspend fun tlsEnabled(`value`: Output<Boolean>) {
        this.tlsEnabled = value
    }

    /**
     * @param value The name of the Access Control List to associate with the cluster.
     */
    @JvmName("yteuokdlfalrxetw")
    public suspend fun aclName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aclName = mapped
    }

    /**
     * @param value When set to `true`, the cluster will automatically receive minor engine version upgrades after launch. Defaults to `true`.
     */
    @JvmName("qlpgolcloaxbtkbv")
    public suspend fun autoMinorVersionUpgrade(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoMinorVersionUpgrade = mapped
    }

    /**
     * @param value Enables data tiering. This option is not supported by all instance types. For more information, see [Data tiering](https://docs.aws.amazon.com/memorydb/latest/devguide/data-tiering.html).
     */
    @JvmName("iphjyukswwjmefal")
    public suspend fun dataTiering(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataTiering = mapped
    }

    /**
     * @param value Description for the cluster.
     */
    @JvmName("boadsrxwwpptkgdw")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Version number of the Redis engine to be used for the cluster. Downgrades are not supported.
     */
    @JvmName("cqngjlfqoslnpefd")
    public suspend fun engineVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engineVersion = mapped
    }

    /**
     * @param value Name of the final cluster snapshot to be created when this resource is deleted. If omitted, no final snapshot will be made.
     */
    @JvmName("qgxvgjkhtnldlpym")
    public suspend fun finalSnapshotName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.finalSnapshotName = mapped
    }

    /**
     * @param value ARN of the KMS key used to encrypt the cluster at rest.
     */
    @JvmName("deldnsvovdngwdnv")
    public suspend fun kmsKeyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyArn = mapped
    }

    /**
     * @param value Specifies the weekly time range during which maintenance on the cluster is performed. Specify as a range in the format `ddd:hh24:mi-ddd:hh24:mi` (24H Clock UTC). The minimum maintenance window is a 60 minute period. Example: `sun:23:00-mon:01:30`.
     */
    @JvmName("qskfpeewktyckhuq")
    public suspend fun maintenanceWindow(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintenanceWindow = mapped
    }

    /**
     * @param value Name of the cluster. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    @JvmName("feweijrgclkmhwyr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("edclfpcboujjdyfc")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value The compute and memory capacity of the nodes in the cluster. See AWS documentation on [supported node types](https://docs&#46;aws&#46;amazon&#46;com/memorydb/latest/devguide/nodes&#46;supportedtypes&#46;html) as well as [vertical scaling](https://docs.aws.amazon.com/memorydb/latest/devguide/cluster-vertical-scaling.html).
     * The following arguments are optional:
     */
    @JvmName("kcneugyhjbbdkxpr")
    public suspend fun nodeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeType = mapped
    }

    /**
     * @param value The number of replicas to apply to each shard, up to a maximum of 5. Defaults to `1` (i.e. 2 nodes per shard).
     */
    @JvmName("ddjpfuvftcfxtvjc")
    public suspend fun numReplicasPerShard(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numReplicasPerShard = mapped
    }

    /**
     * @param value The number of shards in the cluster. Defaults to `1`.
     */
    @JvmName("ehkkksmrlsfagxlm")
    public suspend fun numShards(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numShards = mapped
    }

    /**
     * @param value The name of the parameter group associated with the cluster.
     */
    @JvmName("ctpkmmvxlgfuupmk")
    public suspend fun parameterGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameterGroupName = mapped
    }

    /**
     * @param value The port number on which each of the nodes accepts connections. Defaults to `6379`.
     */
    @JvmName("dfskpdslgqotubbs")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Set of VPC Security Group ID-s to associate with this cluster.
     */
    @JvmName("kvwsnqsrbshcrrhj")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values Set of VPC Security Group ID-s to associate with this cluster.
     */
    @JvmName("ifhfmguerywwjwhg")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value List of ARN-s that uniquely identify RDB snapshot files stored in S3. The snapshot files will be used to populate the new cluster. Object names in the ARN-s cannot contain any commas.
     */
    @JvmName("kqydwyisjqgdklde")
    public suspend fun snapshotArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotArns = mapped
    }

    /**
     * @param values List of ARN-s that uniquely identify RDB snapshot files stored in S3. The snapshot files will be used to populate the new cluster. Object names in the ARN-s cannot contain any commas.
     */
    @JvmName("aywfvmcwtsfrfhuj")
    public suspend fun snapshotArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.snapshotArns = mapped
    }

    /**
     * @param value The name of a snapshot from which to restore data into the new cluster.
     */
    @JvmName("cololqbvxclplytk")
    public suspend fun snapshotName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotName = mapped
    }

    /**
     * @param value The number of days for which MemoryDB retains automatic snapshots before deleting them. When set to `0`, automatic backups are disabled. Defaults to `0`.
     */
    @JvmName("wxaqhtxbvvbhpyds")
    public suspend fun snapshotRetentionLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotRetentionLimit = mapped
    }

    /**
     * @param value The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your shard. Example: `05:00-09:00`.
     */
    @JvmName("kdlywlhvvukckmgu")
    public suspend fun snapshotWindow(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotWindow = mapped
    }

    /**
     * @param value ARN of the SNS topic to which cluster notifications are sent.
     */
    @JvmName("pxvqfdqypmycvbkl")
    public suspend fun snsTopicArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snsTopicArn = mapped
    }

    /**
     * @param value The name of the subnet group to be used for the cluster. Defaults to a subnet group consisting of default VPC subnets.
     */
    @JvmName("wubcvxihlqnwnmnq")
    public suspend fun subnetGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetGroupName = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("abtpsqehifvhqkmd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("oubhebmqgnmdfrnp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value A flag to enable in-transit encryption on the cluster. When set to `false`, the `acl_name` must be `open-access`. Defaults to `true`.
     */
    @JvmName("yvtacypgpitvtbek")
    public suspend fun tlsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tlsEnabled = mapped
    }

    internal fun build(): ClusterArgs = ClusterArgs(
        aclName = aclName,
        autoMinorVersionUpgrade = autoMinorVersionUpgrade,
        dataTiering = dataTiering,
        description = description,
        engineVersion = engineVersion,
        finalSnapshotName = finalSnapshotName,
        kmsKeyArn = kmsKeyArn,
        maintenanceWindow = maintenanceWindow,
        name = name,
        namePrefix = namePrefix,
        nodeType = nodeType,
        numReplicasPerShard = numReplicasPerShard,
        numShards = numShards,
        parameterGroupName = parameterGroupName,
        port = port,
        securityGroupIds = securityGroupIds,
        snapshotArns = snapshotArns,
        snapshotName = snapshotName,
        snapshotRetentionLimit = snapshotRetentionLimit,
        snapshotWindow = snapshotWindow,
        snsTopicArn = snsTopicArn,
        subnetGroupName = subnetGroupName,
        tags = tags,
        tlsEnabled = tlsEnabled,
    )
}
