@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.memorydb.kotlin

import com.pulumi.aws.memorydb.ParameterGroupArgs.builder
import com.pulumi.aws.memorydb.kotlin.inputs.ParameterGroupParameterArgs
import com.pulumi.aws.memorydb.kotlin.inputs.ParameterGroupParameterArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a MemoryDB Parameter Group.
 * More information about parameter groups can be found in the [MemoryDB User Guide](https://docs.aws.amazon.com/memorydb/latest/devguide/parametergroups.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.memorydb.ParameterGroup;
 * import com.pulumi.aws.memorydb.ParameterGroupArgs;
 * import com.pulumi.aws.memorydb.inputs.ParameterGroupParameterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ParameterGroup("example", ParameterGroupArgs.builder()
 *             .family("memorydb_redis6")
 *             .parameters(ParameterGroupParameterArgs.builder()
 *                 .name("activedefrag")
 *                 .value("yes")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import a parameter group using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:memorydb/parameterGroup:ParameterGroup example my-parameter-group
 * ```
 * @property description Description for the parameter group.
 * @property family The engine version that the parameter group can be used with.
 * The following arguments are optional:
 * @property name Name of the parameter group. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
 * @property namePrefix Creates a unique name beginning with the specified prefix. Conflicts with `name`.
 * @property parameters Set of MemoryDB parameters to apply. Any parameters not specified will fall back to their family defaults. Detailed below.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ParameterGroupArgs(
    public val description: Output<String>? = null,
    public val family: Output<String>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val parameters: Output<List<ParameterGroupParameterArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.memorydb.ParameterGroupArgs> {
    override fun toJava(): com.pulumi.aws.memorydb.ParameterGroupArgs =
        com.pulumi.aws.memorydb.ParameterGroupArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .family(family?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ParameterGroupArgs].
 */
@PulumiTagMarker
public class ParameterGroupArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var family: Output<String>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var parameters: Output<List<ParameterGroupParameterArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Description for the parameter group.
     */
    @JvmName("xyhcmhkfgxxgvfch")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The engine version that the parameter group can be used with.
     * The following arguments are optional:
     */
    @JvmName("firmmulmqxjteapa")
    public suspend fun family(`value`: Output<String>) {
        this.family = value
    }

    /**
     * @param value Name of the parameter group. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    @JvmName("gmtyjpbqjdkbxplv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("hdnktofaaacqooge")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value Set of MemoryDB parameters to apply. Any parameters not specified will fall back to their family defaults. Detailed below.
     */
    @JvmName("fvnsogsoqkklteka")
    public suspend fun parameters(`value`: Output<List<ParameterGroupParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("notirolqafibnylp")
    public suspend fun parameters(vararg values: Output<ParameterGroupParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values Set of MemoryDB parameters to apply. Any parameters not specified will fall back to their family defaults. Detailed below.
     */
    @JvmName("vaqiomwclwwnkejs")
    public suspend fun parameters(values: List<Output<ParameterGroupParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("sqqdwckiimslpdin")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Description for the parameter group.
     */
    @JvmName("bsklkuhfcceuawcn")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The engine version that the parameter group can be used with.
     * The following arguments are optional:
     */
    @JvmName("nnmowkubenulmwmc")
    public suspend fun family(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.family = mapped
    }

    /**
     * @param value Name of the parameter group. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    @JvmName("noxdrxevfceayujh")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("ydionydyqgyqghft")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value Set of MemoryDB parameters to apply. Any parameters not specified will fall back to their family defaults. Detailed below.
     */
    @JvmName("yadhmkkufreyqjpj")
    public suspend fun parameters(`value`: List<ParameterGroupParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Set of MemoryDB parameters to apply. Any parameters not specified will fall back to their family defaults. Detailed below.
     */
    @JvmName("asmeecbriksodprq")
    public suspend
    fun parameters(argument: List<suspend ParameterGroupParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ParameterGroupParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Set of MemoryDB parameters to apply. Any parameters not specified will fall back to their family defaults. Detailed below.
     */
    @JvmName("xxdfrwujnpnkaxee")
    public suspend fun parameters(
        vararg
        argument: suspend ParameterGroupParameterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ParameterGroupParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Set of MemoryDB parameters to apply. Any parameters not specified will fall back to their family defaults. Detailed below.
     */
    @JvmName("fphlbewxrxsqhhsi")
    public suspend fun parameters(argument: suspend ParameterGroupParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ParameterGroupParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Set of MemoryDB parameters to apply. Any parameters not specified will fall back to their family defaults. Detailed below.
     */
    @JvmName("ydkybovwsbcbliai")
    public suspend fun parameters(vararg values: ParameterGroupParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ifryimtbglsplqhm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("eynwqkcxncnsxiwf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ParameterGroupArgs = ParameterGroupArgs(
        description = description,
        family = family,
        name = name,
        namePrefix = namePrefix,
        parameters = parameters,
        tags = tags,
    )
}
