@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.memorydb.kotlin

import com.pulumi.aws.memorydb.UserArgs.builder
import com.pulumi.aws.memorydb.kotlin.inputs.UserAuthenticationModeArgs
import com.pulumi.aws.memorydb.kotlin.inputs.UserAuthenticationModeArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a MemoryDB User.
 * More information about users and ACL-s can be found in the [MemoryDB User Guide](https://docs.aws.amazon.com/memorydb/latest/devguide/clusters.acls.html).
 * > **Note:** All arguments including the username and passwords will be stored in the raw state as plain-text.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.RandomPassword;
 * import com.pulumi.random.RandomPasswordArgs;
 * import com.pulumi.aws.memorydb.User;
 * import com.pulumi.aws.memorydb.UserArgs;
 * import com.pulumi.aws.memorydb.inputs.UserAuthenticationModeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleRandomPassword = new RandomPassword("exampleRandomPassword", RandomPasswordArgs.builder()
 *             .length(16)
 *             .build());
 *         var exampleUser = new User("exampleUser", UserArgs.builder()
 *             .userName("my-user")
 *             .accessString("on ~* &* +@all")
 *             .authenticationMode(UserAuthenticationModeArgs.builder()
 *                 .type("password")
 *                 .passwords(exampleRandomPassword.result())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import a user using the `user_name`. For example:
 * ```sh
 *  $ pulumi import aws:memorydb/user:User example my-user
 * ```
 *  The `passwords` are not available for imported resources, as this information cannot be read back from the MemoryDB API.
 * @property accessString The access permissions string used for this user.
 * @property authenticationMode Denotes the user's authentication properties. Detailed below.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property userName Name of the MemoryDB user. Up to 40 characters.
 * The following arguments are optional:
 */
public data class UserArgs(
    public val accessString: Output<String>? = null,
    public val authenticationMode: Output<UserAuthenticationModeArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val userName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.memorydb.UserArgs> {
    override fun toJava(): com.pulumi.aws.memorydb.UserArgs =
        com.pulumi.aws.memorydb.UserArgs.builder()
            .accessString(accessString?.applyValue({ args0 -> args0 }))
            .authenticationMode(
                authenticationMode?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserArgs].
 */
@PulumiTagMarker
public class UserArgsBuilder internal constructor() {
    private var accessString: Output<String>? = null

    private var authenticationMode: Output<UserAuthenticationModeArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var userName: Output<String>? = null

    /**
     * @param value The access permissions string used for this user.
     */
    @JvmName("vlemodblsenugchq")
    public suspend fun accessString(`value`: Output<String>) {
        this.accessString = value
    }

    /**
     * @param value Denotes the user's authentication properties. Detailed below.
     */
    @JvmName("kiccntgusxrcvwdk")
    public suspend fun authenticationMode(`value`: Output<UserAuthenticationModeArgs>) {
        this.authenticationMode = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vwefmatalnaumpfn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the MemoryDB user. Up to 40 characters.
     * The following arguments are optional:
     */
    @JvmName("eqrwebrofvbfowbw")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value The access permissions string used for this user.
     */
    @JvmName("wohjcneoatgubube")
    public suspend fun accessString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessString = mapped
    }

    /**
     * @param value Denotes the user's authentication properties. Detailed below.
     */
    @JvmName("rwofbutxeilrvjhk")
    public suspend fun authenticationMode(`value`: UserAuthenticationModeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationMode = mapped
    }

    /**
     * @param argument Denotes the user's authentication properties. Detailed below.
     */
    @JvmName("opmwxnrfiyuyxlen")
    public suspend
    fun authenticationMode(argument: suspend UserAuthenticationModeArgsBuilder.() -> Unit) {
        val toBeMapped = UserAuthenticationModeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.authenticationMode = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ygflutbcuqgjgjcq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mfubdaaflitcbtmy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Name of the MemoryDB user. Up to 40 characters.
     * The following arguments are optional:
     */
    @JvmName("rikthwmdhogjmtlq")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): UserArgs = UserArgs(
        accessString = accessString,
        authenticationMode = authenticationMode,
        tags = tags,
        userName = userName,
    )
}
