@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.memorydb.kotlin.inputs

import com.pulumi.aws.memorydb.inputs.GetSnapshotPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSnapshot.
 * @property name Name of the snapshot.
 * @property tags Map of tags assigned to the snapshot.
 */
public data class GetSnapshotPlainArgs(
    public val name: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.memorydb.inputs.GetSnapshotPlainArgs> {
    override fun toJava(): com.pulumi.aws.memorydb.inputs.GetSnapshotPlainArgs =
        com.pulumi.aws.memorydb.inputs.GetSnapshotPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetSnapshotPlainArgs].
 */
@PulumiTagMarker
public class GetSnapshotPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Name of the snapshot.
     */
    @JvmName("akpdshvyvgoacdfe")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Map of tags assigned to the snapshot.
     */
    @JvmName("hpnssmjspknxytfk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags assigned to the snapshot.
     */
    @JvmName("kxrahpfqekbivrpy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetSnapshotPlainArgs = GetSnapshotPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        tags = tags,
    )
}
