@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.memorydb.kotlin.inputs

import com.pulumi.aws.memorydb.inputs.GetUserPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getUser.
 * @property tags Map of tags assigned to the subnet group.
 * @property userName Name of the user.
 */
public data class GetUserPlainArgs(
    public val tags: Map<String, String>? = null,
    public val userName: String,
) : ConvertibleToJava<com.pulumi.aws.memorydb.inputs.GetUserPlainArgs> {
    override fun toJava(): com.pulumi.aws.memorydb.inputs.GetUserPlainArgs =
        com.pulumi.aws.memorydb.inputs.GetUserPlainArgs.builder()
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userName(userName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetUserPlainArgs].
 */
@PulumiTagMarker
public class GetUserPlainArgsBuilder internal constructor() {
    private var tags: Map<String, String>? = null

    private var userName: String? = null

    /**
     * @param value Map of tags assigned to the subnet group.
     */
    @JvmName("dmrpwyhrcyflmjmx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags assigned to the subnet group.
     */
    @JvmName("ncvgmunkqyxqgdgj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value Name of the user.
     */
    @JvmName("lcgmdwoxuieganxi")
    public suspend fun userName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.userName = mapped
    }

    internal fun build(): GetUserPlainArgs = GetUserPlainArgs(
        tags = tags,
        userName = userName ?: throw PulumiNullFieldException("userName"),
    )
}
