@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.memorydb.kotlin.inputs

import com.pulumi.aws.memorydb.inputs.UserAuthenticationModeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property passwordCount The number of passwords belonging to the user.
 * @property passwords The set of passwords used for authentication. You can create up to two passwords for each user.
 * @property type Indicates whether the user requires a password to authenticate. Must be set to `password`.
 */
public data class UserAuthenticationModeArgs(
    public val passwordCount: Output<Int>? = null,
    public val passwords: Output<List<String>>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.memorydb.inputs.UserAuthenticationModeArgs> {
    override fun toJava(): com.pulumi.aws.memorydb.inputs.UserAuthenticationModeArgs =
        com.pulumi.aws.memorydb.inputs.UserAuthenticationModeArgs.builder()
            .passwordCount(passwordCount?.applyValue({ args0 -> args0 }))
            .passwords(passwords.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserAuthenticationModeArgs].
 */
@PulumiTagMarker
public class UserAuthenticationModeArgsBuilder internal constructor() {
    private var passwordCount: Output<Int>? = null

    private var passwords: Output<List<String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value The number of passwords belonging to the user.
     */
    @JvmName("hitggaudpnnuwsof")
    public suspend fun passwordCount(`value`: Output<Int>) {
        this.passwordCount = value
    }

    /**
     * @param value The set of passwords used for authentication. You can create up to two passwords for each user.
     */
    @JvmName("rhwkqtxbvvcoadkw")
    public suspend fun passwords(`value`: Output<List<String>>) {
        this.passwords = value
    }

    @JvmName("itemwjyvyctlvpil")
    public suspend fun passwords(vararg values: Output<String>) {
        this.passwords = Output.all(values.asList())
    }

    /**
     * @param values The set of passwords used for authentication. You can create up to two passwords for each user.
     */
    @JvmName("yulwgwvirohugnxx")
    public suspend fun passwords(values: List<Output<String>>) {
        this.passwords = Output.all(values)
    }

    /**
     * @param value Indicates whether the user requires a password to authenticate. Must be set to `password`.
     */
    @JvmName("xvlgobkucdpmhgsf")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The number of passwords belonging to the user.
     */
    @JvmName("giwphvbxgxvsnetp")
    public suspend fun passwordCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passwordCount = mapped
    }

    /**
     * @param value The set of passwords used for authentication. You can create up to two passwords for each user.
     */
    @JvmName("dtadfxkynciqlrvb")
    public suspend fun passwords(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.passwords = mapped
    }

    /**
     * @param values The set of passwords used for authentication. You can create up to two passwords for each user.
     */
    @JvmName("mtpskyoqbskmmwsr")
    public suspend fun passwords(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.passwords = mapped
    }

    /**
     * @param value Indicates whether the user requires a password to authenticate. Must be set to `password`.
     */
    @JvmName("meavockvbcpstrqc")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): UserAuthenticationModeArgs = UserAuthenticationModeArgs(
        passwordCount = passwordCount,
        passwords = passwords ?: throw PulumiNullFieldException("passwords"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
