@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.memorydb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property name Name of the cluster. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
 * @property nodes Set of nodes in this shard.
 * @property numNodes Number of individual nodes in this shard.
 * @property slots Keyspace for this shard. Example: `0-16383`.
 */
public data class ClusterShard(
    public val name: String? = null,
    public val nodes: List<ClusterShardNode>? = null,
    public val numNodes: Int? = null,
    public val slots: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.memorydb.outputs.ClusterShard): ClusterShard =
            ClusterShard(
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
                nodes = javaType.nodes().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.memorydb.kotlin.outputs.ClusterShardNode.Companion.toKotlin(args0)
                    })
                }),
                numNodes = javaType.numNodes().map({ args0 -> args0 }).orElse(null),
                slots = javaType.slots().map({ args0 -> args0 }).orElse(null),
            )
    }
}
