@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.memorydb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property availabilityZone The Availability Zone in which the node resides.
 * @property createTime The date and time when the node was created. Example: `2022-01-01T21:00:00Z`.
 * @property endpoints
 * @property name Name of the cluster. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
 */
public data class ClusterShardNode(
    public val availabilityZone: String? = null,
    public val createTime: String? = null,
    public val endpoints: List<ClusterShardNodeEndpoint>? = null,
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.memorydb.outputs.ClusterShardNode):
            ClusterShardNode = ClusterShardNode(
            availabilityZone = javaType.availabilityZone().map({ args0 -> args0 }).orElse(null),
            createTime = javaType.createTime().map({ args0 -> args0 }).orElse(null),
            endpoints = javaType.endpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.memorydb.kotlin.outputs.ClusterShardNodeEndpoint.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
