@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.memorydb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property address DNS hostname of the node.
 * @property port The port number on which each of the nodes accepts connections. Defaults to `6379`.
 */
public data class ClusterShardNodeEndpoint(
    public val address: String? = null,
    public val port: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.memorydb.outputs.ClusterShardNodeEndpoint):
            ClusterShardNodeEndpoint = ClusterShardNodeEndpoint(
            address = javaType.address().map({ args0 -> args0 }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
        )
    }
}
