@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.memorydb.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getCluster.
 * @property aclName Name of the Access Control List associated with the cluster.
 * @property arn ARN of the cluster.
 * @property autoMinorVersionUpgrade True when the cluster allows automatic minor version upgrades.
 * @property clusterEndpoints
 * @property dataTiering True when data tiering is enabled.
 * @property description Description for the cluster.
 * @property enginePatchVersion Patch version number of the Redis engine used by the cluster.
 * @property engineVersion Version number of the Redis engine used by the cluster.
 * @property finalSnapshotName Name of the final cluster snapshot to be created when this resource is deleted. If omitted, no final snapshot will be made.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property kmsKeyArn ARN of the KMS key used to encrypt the cluster at rest.
 * @property maintenanceWindow Weekly time range during which maintenance on the cluster is performed. Specify as a range in the format `ddd:hh24:mi-ddd:hh24:mi` (24H Clock UTC). Example: `sun:23:00-mon:01:30`.
 * @property name Name of this node.
 * @property nodeType Compute and memory capacity of the nodes in the cluster.
 * @property numReplicasPerShard The number of replicas to apply to each shard.
 * @property numShards Number of shards in the cluster.
 * @property parameterGroupName The name of the parameter group associated with the cluster.
 * @property port Port number that this node is listening on.
 * @property securityGroupIds Set of VPC Security Group ID-s associated with this cluster.
 * @property shards Set of shards in this cluster.
 * @property snapshotRetentionLimit The number of days for which MemoryDB retains automatic snapshots before deleting them. When set to `0`, automatic backups are disabled.
 * @property snapshotWindow Daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your shard. Example: `05:00-09:00`.
 * @property snsTopicArn ARN of the SNS topic to which cluster notifications are sent.
 * @property subnetGroupName The name of the subnet group used for the cluster.
 * @property tags Map of tags assigned to the cluster.
 * @property tlsEnabled When true, in-transit encryption is enabled for the cluster.
 */
public data class GetClusterResult(
    public val aclName: String,
    public val arn: String,
    public val autoMinorVersionUpgrade: Boolean,
    public val clusterEndpoints: List<GetClusterClusterEndpoint>,
    public val dataTiering: Boolean,
    public val description: String,
    public val enginePatchVersion: String,
    public val engineVersion: String,
    public val finalSnapshotName: String,
    public val id: String,
    public val kmsKeyArn: String,
    public val maintenanceWindow: String,
    public val name: String,
    public val nodeType: String,
    public val numReplicasPerShard: Int,
    public val numShards: Int,
    public val parameterGroupName: String,
    public val port: Int,
    public val securityGroupIds: List<String>,
    public val shards: List<GetClusterShard>,
    public val snapshotRetentionLimit: Int,
    public val snapshotWindow: String,
    public val snsTopicArn: String,
    public val subnetGroupName: String,
    public val tags: Map<String, String>,
    public val tlsEnabled: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.memorydb.outputs.GetClusterResult):
            GetClusterResult = GetClusterResult(
            aclName = javaType.aclName(),
            arn = javaType.arn(),
            autoMinorVersionUpgrade = javaType.autoMinorVersionUpgrade(),
            clusterEndpoints = javaType.clusterEndpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.memorydb.kotlin.outputs.GetClusterClusterEndpoint.Companion.toKotlin(args0)
                })
            }),
            dataTiering = javaType.dataTiering(),
            description = javaType.description(),
            enginePatchVersion = javaType.enginePatchVersion(),
            engineVersion = javaType.engineVersion(),
            finalSnapshotName = javaType.finalSnapshotName(),
            id = javaType.id(),
            kmsKeyArn = javaType.kmsKeyArn(),
            maintenanceWindow = javaType.maintenanceWindow(),
            name = javaType.name(),
            nodeType = javaType.nodeType(),
            numReplicasPerShard = javaType.numReplicasPerShard(),
            numShards = javaType.numShards(),
            parameterGroupName = javaType.parameterGroupName(),
            port = javaType.port(),
            securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
            shards = javaType.shards().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.memorydb.kotlin.outputs.GetClusterShard.Companion.toKotlin(args0)
                })
            }),
            snapshotRetentionLimit = javaType.snapshotRetentionLimit(),
            snapshotWindow = javaType.snapshotWindow(),
            snsTopicArn = javaType.snsTopicArn(),
            subnetGroupName = javaType.subnetGroupName(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            tlsEnabled = javaType.tlsEnabled(),
        )
    }
}
