@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.memorydb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property name Name of the cluster.
 * @property nodes Set of nodes in this shard.
 * @property numNodes Number of individual nodes in this shard.
 * @property slots Keyspace for this shard. Example: `0-16383`.
 */
public data class GetClusterShard(
    public val name: String,
    public val nodes: List<GetClusterShardNode>,
    public val numNodes: Int,
    public val slots: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.memorydb.outputs.GetClusterShard): GetClusterShard =
            GetClusterShard(
                name = javaType.name(),
                nodes = javaType.nodes().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.memorydb.kotlin.outputs.GetClusterShardNode.Companion.toKotlin(args0)
                    })
                }),
                numNodes = javaType.numNodes(),
                slots = javaType.slots(),
            )
    }
}
