@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.memorydb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property availabilityZone The Availability Zone in which the node resides.
 * @property createTime The date and time when the node was created. Example: `2022-01-01T21:00:00Z`.
 * @property endpoints
 * @property name Name of the cluster.
 */
public data class GetClusterShardNode(
    public val availabilityZone: String,
    public val createTime: String,
    public val endpoints: List<GetClusterShardNodeEndpoint>,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.memorydb.outputs.GetClusterShardNode):
            GetClusterShardNode = GetClusterShardNode(
            availabilityZone = javaType.availabilityZone(),
            createTime = javaType.createTime(),
            endpoints = javaType.endpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.memorydb.kotlin.outputs.GetClusterShardNodeEndpoint.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
        )
    }
}
