@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.memorydb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getSnapshot.
 * @property arn ARN of the snapshot.
 * @property clusterConfigurations The configuration of the cluster from which the snapshot was taken.
 * @property clusterName Name of the MemoryDB cluster that this snapshot was taken from.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property kmsKeyArn ARN of the KMS key used to encrypt the snapshot at rest.
 * @property name Name of the cluster.
 * @property source Whether the snapshot is from an automatic backup (`automated`) or was created manually (`manual`).
 * @property tags Map of tags assigned to the snapshot.
 */
public data class GetSnapshotResult(
    public val arn: String,
    public val clusterConfigurations: List<GetSnapshotClusterConfiguration>,
    public val clusterName: String,
    public val id: String,
    public val kmsKeyArn: String,
    public val name: String,
    public val source: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.memorydb.outputs.GetSnapshotResult):
            GetSnapshotResult = GetSnapshotResult(
            arn = javaType.arn(),
            clusterConfigurations = javaType.clusterConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.memorydb.kotlin.outputs.GetSnapshotClusterConfiguration.Companion.toKotlin(args0)
                })
            }),
            clusterName = javaType.clusterName(),
            id = javaType.id(),
            kmsKeyArn = javaType.kmsKeyArn(),
            name = javaType.name(),
            source = javaType.source(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
