@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.memorydb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property passwordCount The number of passwords belonging to the user.
 * @property type Whether the user requires a password to authenticate.
 */
public data class GetUserAuthenticationMode(
    public val passwordCount: Int,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.memorydb.outputs.GetUserAuthenticationMode):
            GetUserAuthenticationMode = GetUserAuthenticationMode(
            passwordCount = javaType.passwordCount(),
            type = javaType.type(),
        )
    }
}
