@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.memorydb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property description Description for the cluster.
 * @property engineVersion Version number of the Redis engine used by the cluster.
 * @property maintenanceWindow The weekly time range during which maintenance on the cluster is performed.
 * @property name Name of the snapshot. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
 * @property nodeType Compute and memory capacity of the nodes in the cluster.
 * @property numShards Number of shards in the cluster.
 * @property parameterGroupName Name of the parameter group associated with the cluster.
 * @property port Port number on which the cluster accepts connections.
 * @property snapshotRetentionLimit Number of days for which MemoryDB retains automatic snapshots before deleting them.
 * @property snapshotWindow The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of the shard.
 * @property subnetGroupName Name of the subnet group used by the cluster.
 * @property topicArn ARN of the SNS topic to which cluster notifications are sent.
 * @property vpcId The VPC in which the cluster exists.
 */
public data class SnapshotClusterConfiguration(
    public val description: String? = null,
    public val engineVersion: String? = null,
    public val maintenanceWindow: String? = null,
    public val name: String? = null,
    public val nodeType: String? = null,
    public val numShards: Int? = null,
    public val parameterGroupName: String? = null,
    public val port: Int? = null,
    public val snapshotRetentionLimit: Int? = null,
    public val snapshotWindow: String? = null,
    public val subnetGroupName: String? = null,
    public val topicArn: String? = null,
    public val vpcId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.memorydb.outputs.SnapshotClusterConfiguration):
            SnapshotClusterConfiguration = SnapshotClusterConfiguration(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            engineVersion = javaType.engineVersion().map({ args0 -> args0 }).orElse(null),
            maintenanceWindow = javaType.maintenanceWindow().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            nodeType = javaType.nodeType().map({ args0 -> args0 }).orElse(null),
            numShards = javaType.numShards().map({ args0 -> args0 }).orElse(null),
            parameterGroupName = javaType.parameterGroupName().map({ args0 -> args0 }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            snapshotRetentionLimit = javaType.snapshotRetentionLimit().map({ args0 -> args0 }).orElse(null),
            snapshotWindow = javaType.snapshotWindow().map({ args0 -> args0 }).orElse(null),
            subnetGroupName = javaType.subnetGroupName().map({ args0 -> args0 }).orElse(null),
            topicArn = javaType.topicArn().map({ args0 -> args0 }).orElse(null),
            vpcId = javaType.vpcId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
