@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.memorydb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property passwordCount The number of passwords belonging to the user.
 * @property passwords The set of passwords used for authentication. You can create up to two passwords for each user.
 * @property type Indicates whether the user requires a password to authenticate. Must be set to `password`.
 */
public data class UserAuthenticationMode(
    public val passwordCount: Int? = null,
    public val passwords: List<String>,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.memorydb.outputs.UserAuthenticationMode):
            UserAuthenticationMode = UserAuthenticationMode(
            passwordCount = javaType.passwordCount().map({ args0 -> args0 }).orElse(null),
            passwords = javaType.passwords().map({ args0 -> args0 }),
            type = javaType.type(),
        )
    }
}
