@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mq.kotlin

import com.pulumi.aws.mq.kotlin.outputs.BrokerConfiguration
import com.pulumi.aws.mq.kotlin.outputs.BrokerEncryptionOptions
import com.pulumi.aws.mq.kotlin.outputs.BrokerInstance
import com.pulumi.aws.mq.kotlin.outputs.BrokerLdapServerMetadata
import com.pulumi.aws.mq.kotlin.outputs.BrokerLogs
import com.pulumi.aws.mq.kotlin.outputs.BrokerMaintenanceWindowStartTime
import com.pulumi.aws.mq.kotlin.outputs.BrokerUser
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.mq.kotlin.outputs.BrokerConfiguration.Companion.toKotlin as brokerConfigurationToKotlin
import com.pulumi.aws.mq.kotlin.outputs.BrokerEncryptionOptions.Companion.toKotlin as brokerEncryptionOptionsToKotlin
import com.pulumi.aws.mq.kotlin.outputs.BrokerInstance.Companion.toKotlin as brokerInstanceToKotlin
import com.pulumi.aws.mq.kotlin.outputs.BrokerLdapServerMetadata.Companion.toKotlin as brokerLdapServerMetadataToKotlin
import com.pulumi.aws.mq.kotlin.outputs.BrokerLogs.Companion.toKotlin as brokerLogsToKotlin
import com.pulumi.aws.mq.kotlin.outputs.BrokerMaintenanceWindowStartTime.Companion.toKotlin as brokerMaintenanceWindowStartTimeToKotlin
import com.pulumi.aws.mq.kotlin.outputs.BrokerUser.Companion.toKotlin as brokerUserToKotlin

/**
 * Builder for [Broker].
 */
@PulumiTagMarker
public class BrokerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BrokerArgs = BrokerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BrokerArgsBuilder.() -> Unit) {
        val builder = BrokerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Broker {
        val builtJavaResource = com.pulumi.aws.mq.Broker(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Broker(builtJavaResource)
    }
}

/**
 * Provides an Amazon MQ broker resource. This resources also manages users for the broker.
 * > For more information on Amazon MQ, see [Amazon MQ documentation](https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/welcome.html).
 * > **NOTE:** Amazon MQ currently places limits on **RabbitMQ** brokers. For example, a RabbitMQ broker cannot have: instances with an associated IP address of an ENI attached to the broker, an associated LDAP server to authenticate and authorize broker connections, storage type `EFS`, or audit logging. Although this resource allows you to create RabbitMQ users, RabbitMQ users cannot have console access or groups. Also, Amazon MQ does not return information about RabbitMQ users so drift detection is not possible.
 * > **NOTE:** Changes to an MQ Broker can occur when you change a parameter, such as `configuration` or `user`, and are reflected in the next maintenance window. Because of this, the provider may report a difference in its planning phase because a modification has not yet taken place. You can use the `apply_immediately` flag to instruct the service to apply the change immediately (see documentation below). Using `apply_immediately` can result in a brief downtime as the broker reboots.
 * ## Example Usage
 * ### Basic Example
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.mq.Broker;
 * import com.pulumi.aws.mq.BrokerArgs;
 * import com.pulumi.aws.mq.inputs.BrokerConfigurationArgs;
 * import com.pulumi.aws.mq.inputs.BrokerUserArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Broker("example", BrokerArgs.builder()
 *             .configuration(BrokerConfigurationArgs.builder()
 *                 .id(aws_mq_configuration.test().id())
 *                 .revision(aws_mq_configuration.test().latest_revision())
 *                 .build())
 *             .engineType("ActiveMQ")
 *             .engineVersion("5.17.6")
 *             .hostInstanceType("mq.t2.micro")
 *             .securityGroups(aws_security_group.test().id())
 *             .users(BrokerUserArgs.builder()
 *                 .username("ExampleUser")
 *                 .password("MindTheGap")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### High-throughput Optimized Example
 * This example shows the use of EBS storage for high-throughput optimized performance.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.mq.Broker;
 * import com.pulumi.aws.mq.BrokerArgs;
 * import com.pulumi.aws.mq.inputs.BrokerConfigurationArgs;
 * import com.pulumi.aws.mq.inputs.BrokerUserArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Broker("example", BrokerArgs.builder()
 *             .configuration(BrokerConfigurationArgs.builder()
 *                 .id(aws_mq_configuration.test().id())
 *                 .revision(aws_mq_configuration.test().latest_revision())
 *                 .build())
 *             .engineType("ActiveMQ")
 *             .engineVersion("5.17.6")
 *             .storageType("ebs")
 *             .hostInstanceType("mq.m5.large")
 *             .securityGroups(aws_security_group.test().id())
 *             .users(BrokerUserArgs.builder()
 *                 .username("ExampleUser")
 *                 .password("MindTheGap")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import MQ Brokers using their broker id. For example:
 * ```sh
 *  $ pulumi import aws:mq/broker:Broker example a1b2c3d4-d5f6-7777-8888-9999aaaabbbbcccc
 * ```
 *
 */
public class Broker internal constructor(
    override val javaResource: com.pulumi.aws.mq.Broker,
) : KotlinCustomResource(javaResource, BrokerMapper) {
    /**
     * Specifies whether any broker modifications are applied immediately, or during the next maintenance window. Default is `false`.
     */
    public val applyImmediately: Output<Boolean>?
        get() = javaResource.applyImmediately().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARN of the broker.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Authentication strategy used to secure the broker. Valid values are `simple` and `ldap`. `ldap` is not supported for `engine_type` `RabbitMQ`.
     */
    public val authenticationStrategy: Output<String>
        get() = javaResource.authenticationStrategy().applyValue({ args0 -> args0 })

    /**
     * Whether to automatically upgrade to new minor versions of brokers as Amazon MQ makes releases available.
     */
    public val autoMinorVersionUpgrade: Output<Boolean>?
        get() = javaResource.autoMinorVersionUpgrade().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the broker.
     */
    public val brokerName: Output<String>
        get() = javaResource.brokerName().applyValue({ args0 -> args0 })

    /**
     * Configuration block for broker configuration. Applies to `engine_type` of `ActiveMQ` and `RabbitMQ` only. Detailed below.
     */
    public val configuration: Output<BrokerConfiguration>
        get() = javaResource.configuration().applyValue({ args0 ->
            args0.let({ args0 ->
                brokerConfigurationToKotlin(args0)
            })
        })

    /**
     * Deployment mode of the broker. Valid values are `SINGLE_INSTANCE`, `ACTIVE_STANDBY_MULTI_AZ`, and `CLUSTER_MULTI_AZ`. Default is `SINGLE_INSTANCE`.
     */
    public val deploymentMode: Output<String>?
        get() = javaResource.deploymentMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configuration block containing encryption options. Detailed below.
     */
    public val encryptionOptions: Output<BrokerEncryptionOptions>?
        get() = javaResource.encryptionOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> brokerEncryptionOptionsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Type of broker engine. Valid values are `ActiveMQ` and `RabbitMQ`.
     */
    public val engineType: Output<String>
        get() = javaResource.engineType().applyValue({ args0 -> args0 })

    /**
     * Version of the broker engine. See the [AmazonMQ Broker Engine docs](https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/broker-engine.html) for supported versions. For example, `5.17.6`.
     */
    public val engineVersion: Output<String>
        get() = javaResource.engineVersion().applyValue({ args0 -> args0 })

    /**
     * Broker's instance type. For example, `mq.t3.micro`, `mq.m5.large`.
     */
    public val hostInstanceType: Output<String>
        get() = javaResource.hostInstanceType().applyValue({ args0 -> args0 })

    /**
     * List of information about allocated brokers (both active & standby).
     * * `instances.0.console_url` - The URL of the [ActiveMQ Web Console](http://activemq&#46;apache&#46;org/web-console&#46;html) or the [RabbitMQ Management UI](https://www.rabbitmq.com/management.html#external-monitoring) depending on `engine_type`.
     * * `instances.0.ip_address` - IP Address of the broker.
     * * `instances.0.endpoints` - Broker's wire-level protocol endpoints in the following order & format referenceable e.g., as `instances.0.endpoints.0` (SSL):
     * * For `ActiveMQ`:
     * * `ssl://broker-id.mq.us-west-2.amazonaws.com:61617`
     * * `amqp+ssl://broker-id.mq.us-west-2.amazonaws.com:5671`
     * * `stomp+ssl://broker-id.mq.us-west-2.amazonaws.com:61614`
     * * `mqtt+ssl://broker-id.mq.us-west-2.amazonaws.com:8883`
     * * `wss://broker-id.mq.us-west-2.amazonaws.com:61619`
     * * For `RabbitMQ`:
     * * `amqps://broker-id.mq.us-west-2.amazonaws.com:5671`
     */
    public val instances: Output<List<BrokerInstance>>
        get() = javaResource.instances().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    brokerInstanceToKotlin(args0)
                })
            })
        })

    /**
     * Configuration block for the LDAP server used to authenticate and authorize connections to the broker. Not supported for `engine_type` `RabbitMQ`. Detailed below. (Currently, AWS may not process changes to LDAP server metadata.)
     */
    public val ldapServerMetadata: Output<BrokerLdapServerMetadata>?
        get() = javaResource.ldapServerMetadata().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> brokerLdapServerMetadataToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Configuration block for the logging configuration of the broker. Detailed below.
     */
    public val logs: Output<BrokerLogs>?
        get() = javaResource.logs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    brokerLogsToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Configuration block for the maintenance window start time. Detailed below.
     */
    public val maintenanceWindowStartTime: Output<BrokerMaintenanceWindowStartTime>
        get() = javaResource.maintenanceWindowStartTime().applyValue({ args0 ->
            args0.let({ args0 ->
                brokerMaintenanceWindowStartTimeToKotlin(args0)
            })
        })

    /**
     * Whether to enable connections from applications outside of the VPC that hosts the broker's subnets.
     */
    public val publiclyAccessible: Output<Boolean>?
        get() = javaResource.publiclyAccessible().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of security group IDs assigned to the broker.
     */
    public val securityGroups: Output<List<String>>?
        get() = javaResource.securityGroups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Storage type of the broker. For `engine_type` `ActiveMQ`, the valid values are `efs` and `ebs`, and the AWS-default is `efs`. For `engine_type` `RabbitMQ`, only `ebs` is supported. When using `ebs`, only the `mq.m5` broker instance type family is supported.
     */
    public val storageType: Output<String>
        get() = javaResource.storageType().applyValue({ args0 -> args0 })

    /**
     * List of subnet IDs in which to launch the broker. A `SINGLE_INSTANCE` deployment requires one subnet. An `ACTIVE_STANDBY_MULTI_AZ` deployment requires multiple subnets.
     */
    public val subnetIds: Output<List<String>>
        get() = javaResource.subnetIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Map of tags to assign to the broker. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Configuration block for broker users. For `engine_type` of `RabbitMQ`, Amazon MQ does not return broker users preventing this resource from making user updates and drift detection. Detailed below.
     * The following arguments are optional:
     */
    public val users: Output<List<BrokerUser>>
        get() = javaResource.users().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    brokerUserToKotlin(args0)
                })
            })
        })
}

public object BrokerMapper : ResourceMapper<Broker> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.mq.Broker::class == javaResource::class

    override fun map(javaResource: Resource): Broker = Broker(
        javaResource as
            com.pulumi.aws.mq.Broker,
    )
}

/**
 * @see [Broker].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Broker].
 */
public suspend fun broker(name: String, block: suspend BrokerResourceBuilder.() -> Unit): Broker {
    val builder = BrokerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Broker].
 * @param name The _unique_ name of the resulting resource.
 */
public fun broker(name: String): Broker {
    val builder = BrokerResourceBuilder()
    builder.name(name)
    return builder.build()
}
