@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mq.kotlin

import com.pulumi.aws.mq.ConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an MQ Configuration Resource.
 * For more information on Amazon MQ, see [Amazon MQ documentation](https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/welcome.html).
 * ## Example Usage
 * ### ActiveMQ
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.mq.Configuration;
 * import com.pulumi.aws.mq.ConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Configuration("example", ConfigurationArgs.builder()
 *             .data("""
 * <?xml version="1.0" encoding="UTF-8" standalone="yes"?>
 * <broker xmlns="http://activemq.apache.org/schema/core">
 *   <plugins>
 *     <forcePersistencyModeBrokerPlugin persistenceFlag="true"/>
 *     <statisticsBrokerPlugin/>
 *     <timeStampingBrokerPlugin ttlCeiling="86400000" zeroExpirationOverride="86400000"/>
 *   </plugins>
 * </broker>
 *             """)
 *             .description("Example Configuration")
 *             .engineType("ActiveMQ")
 *             .engineVersion("5.17.6")
 *             .build());
 *     }
 * }
 * ```
 * ### RabbitMQ
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.mq.Configuration;
 * import com.pulumi.aws.mq.ConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Configuration("example", ConfigurationArgs.builder()
 *             .data("""
 * # Default RabbitMQ delivery acknowledgement timeout is 30 minutes in milliseconds
 * consumer_timeout = 1800000
 *             """)
 *             .description("Example Configuration")
 *             .engineType("RabbitMQ")
 *             .engineVersion("3.11.20")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import MQ Configurations using the configuration ID. For example:
 * ```sh
 *  $ pulumi import aws:mq/configuration:Configuration example c-0187d1eb-88c8-475a-9b79-16ef5a10c94f
 * ```
 * @property authenticationStrategy Authentication strategy associated with the configuration. Valid values are `simple` and `ldap`. `ldap` is not supported for `engine_type` `RabbitMQ`.
 * @property data Broker configuration in XML format for `ActiveMQ` or [Cuttlefish](https://github&#46;com/Kyorai/cuttlefish) format for `RabbitMQ`&#46; See [official docs](https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/amazon-mq-broker-configuration-parameters.html) for supported parameters and format of the XML.
 * @property description Description of the configuration.
 * @property engineType Type of broker engine. Valid values are `ActiveMQ` and `RabbitMQ`.
 * @property engineVersion Version of the broker engine.
 * @property name Name of the configuration.
 * The following arguments are optional:
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ConfigurationArgs(
    public val authenticationStrategy: Output<String>? = null,
    public val `data`: Output<String>? = null,
    public val description: Output<String>? = null,
    public val engineType: Output<String>? = null,
    public val engineVersion: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.mq.ConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.mq.ConfigurationArgs =
        com.pulumi.aws.mq.ConfigurationArgs.builder()
            .authenticationStrategy(authenticationStrategy?.applyValue({ args0 -> args0 }))
            .`data`(`data`?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .engineType(engineType?.applyValue({ args0 -> args0 }))
            .engineVersion(engineVersion?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ConfigurationArgs].
 */
@PulumiTagMarker
public class ConfigurationArgsBuilder internal constructor() {
    private var authenticationStrategy: Output<String>? = null

    private var `data`: Output<String>? = null

    private var description: Output<String>? = null

    private var engineType: Output<String>? = null

    private var engineVersion: Output<String>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Authentication strategy associated with the configuration. Valid values are `simple` and `ldap`. `ldap` is not supported for `engine_type` `RabbitMQ`.
     */
    @JvmName("jutxijrgpdlyyofp")
    public suspend fun authenticationStrategy(`value`: Output<String>) {
        this.authenticationStrategy = value
    }

    /**
     * @param value Broker configuration in XML format for `ActiveMQ` or [Cuttlefish](https://github&#46;com/Kyorai/cuttlefish) format for `RabbitMQ`&#46; See [official docs](https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/amazon-mq-broker-configuration-parameters.html) for supported parameters and format of the XML.
     */
    @JvmName("gwcuoiryajaqvehh")
    public suspend fun `data`(`value`: Output<String>) {
        this.`data` = value
    }

    /**
     * @param value Description of the configuration.
     */
    @JvmName("imqmncnltkmehfjs")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Type of broker engine. Valid values are `ActiveMQ` and `RabbitMQ`.
     */
    @JvmName("yaeohcwtrxadcbug")
    public suspend fun engineType(`value`: Output<String>) {
        this.engineType = value
    }

    /**
     * @param value Version of the broker engine.
     */
    @JvmName("bgmxceaplrrkhstb")
    public suspend fun engineVersion(`value`: Output<String>) {
        this.engineVersion = value
    }

    /**
     * @param value Name of the configuration.
     * The following arguments are optional:
     */
    @JvmName("jqdagqedsqjhsybx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("yakybkhotrjhanef")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Authentication strategy associated with the configuration. Valid values are `simple` and `ldap`. `ldap` is not supported for `engine_type` `RabbitMQ`.
     */
    @JvmName("jhhsenkxssbuelap")
    public suspend fun authenticationStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationStrategy = mapped
    }

    /**
     * @param value Broker configuration in XML format for `ActiveMQ` or [Cuttlefish](https://github&#46;com/Kyorai/cuttlefish) format for `RabbitMQ`&#46; See [official docs](https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/amazon-mq-broker-configuration-parameters.html) for supported parameters and format of the XML.
     */
    @JvmName("kwsdpceehyvmpgsh")
    public suspend fun `data`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`data` = mapped
    }

    /**
     * @param value Description of the configuration.
     */
    @JvmName("pdbxewpjcsieqlnm")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Type of broker engine. Valid values are `ActiveMQ` and `RabbitMQ`.
     */
    @JvmName("prjddttiltvjtqbc")
    public suspend fun engineType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engineType = mapped
    }

    /**
     * @param value Version of the broker engine.
     */
    @JvmName("vdrathrxriqrhhab")
    public suspend fun engineVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engineVersion = mapped
    }

    /**
     * @param value Name of the configuration.
     * The following arguments are optional:
     */
    @JvmName("tblchtcwqushxgfd")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cqjtsnealuvhsyac")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("irnpkqtmsgbenqkh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ConfigurationArgs = ConfigurationArgs(
        authenticationStrategy = authenticationStrategy,
        `data` = `data`,
        description = description,
        engineType = engineType,
        engineVersion = engineVersion,
        name = name,
        tags = tags,
    )
}
