@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mq.kotlin

import com.pulumi.aws.mq.MqFunctions.getBrokerPlain
import com.pulumi.aws.mq.MqFunctions.getInstanceTypeOfferingsPlain
import com.pulumi.aws.mq.kotlin.inputs.GetBrokerPlainArgs
import com.pulumi.aws.mq.kotlin.inputs.GetBrokerPlainArgsBuilder
import com.pulumi.aws.mq.kotlin.inputs.GetInstanceTypeOfferingsPlainArgs
import com.pulumi.aws.mq.kotlin.inputs.GetInstanceTypeOfferingsPlainArgsBuilder
import com.pulumi.aws.mq.kotlin.outputs.GetBrokerResult
import com.pulumi.aws.mq.kotlin.outputs.GetInstanceTypeOfferingsResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.mq.kotlin.outputs.GetBrokerResult.Companion.toKotlin as getBrokerResultToKotlin
import com.pulumi.aws.mq.kotlin.outputs.GetInstanceTypeOfferingsResult.Companion.toKotlin as getInstanceTypeOfferingsResultToKotlin

public object MqFunctions {
    /**
     * Provides information about a MQ Broker.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.mq.MqFunctions;
     * import com.pulumi.aws.mq.inputs.GetBrokerArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var brokerId = config.get("brokerId").orElse("");
     *         final var brokerName = config.get("brokerName").orElse("");
     *         final var byId = MqFunctions.getBroker(GetBrokerArgs.builder()
     *             .brokerId(brokerId)
     *             .build());
     *         final var byName = MqFunctions.getBroker(GetBrokerArgs.builder()
     *             .brokerName(brokerName)
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getBroker.
     * @return A collection of values returned by getBroker.
     */
    public suspend fun getBroker(argument: GetBrokerPlainArgs): GetBrokerResult =
        getBrokerResultToKotlin(getBrokerPlain(argument.toJava()).await())

    /**
     * @see [getBroker].
     * @param brokerId Unique id of the mq broker.
     * @param brokerName Unique name of the mq broker.
     * @param tags
     * @return A collection of values returned by getBroker.
     */
    public suspend fun getBroker(
        brokerId: String? = null,
        brokerName: String? = null,
        tags: Map<String, String>? = null,
    ): GetBrokerResult {
        val argument = GetBrokerPlainArgs(
            brokerId = brokerId,
            brokerName = brokerName,
            tags = tags,
        )
        return getBrokerResultToKotlin(getBrokerPlain(argument.toJava()).await())
    }

    /**
     * @see [getBroker].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;mq&#46;kotlin&#46;inputs&#46;GetBrokerPlainArgs].
     * @return A collection of values returned by getBroker.
     */
    public suspend fun getBroker(argument: suspend GetBrokerPlainArgsBuilder.() -> Unit):
        GetBrokerResult {
        val builder = GetBrokerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBrokerResultToKotlin(getBrokerPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides information about a MQ Broker Instance Offerings.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.mq.MqFunctions;
     * import com.pulumi.aws.mq.inputs.GetInstanceTypeOfferingsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var empty = MqFunctions.getInstanceTypeOfferings();
     *         final var engine = MqFunctions.getInstanceTypeOfferings(GetInstanceTypeOfferingsArgs.builder()
     *             .engineType("ACTIVEMQ")
     *             .build());
     *         final var storage = MqFunctions.getInstanceTypeOfferings(GetInstanceTypeOfferingsArgs.builder()
     *             .storageType("EBS")
     *             .build());
     *         final var instance = MqFunctions.getInstanceTypeOfferings(GetInstanceTypeOfferingsArgs.builder()
     *             .hostInstanceType("mq.m5.large")
     *             .build());
     *         final var all = MqFunctions.getInstanceTypeOfferings(GetInstanceTypeOfferingsArgs.builder()
     *             .engineType("ACTIVEMQ")
     *             .hostInstanceType("mq.m5.large")
     *             .storageType("EBS")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getInstanceTypeOfferings.
     * @return A collection of values returned by getInstanceTypeOfferings.
     */
    public suspend fun getInstanceTypeOfferings(argument: GetInstanceTypeOfferingsPlainArgs):
        GetInstanceTypeOfferingsResult =
        getInstanceTypeOfferingsResultToKotlin(getInstanceTypeOfferingsPlain(argument.toJava()).await())

    /**
     * @see [getInstanceTypeOfferings].
     * @param engineType Filter response by engine type.
     * @param hostInstanceType Filter response by host instance type.
     * @param storageType Filter response by storage type.
     * @return A collection of values returned by getInstanceTypeOfferings.
     */
    public suspend fun getInstanceTypeOfferings(
        engineType: String? = null,
        hostInstanceType: String? = null,
        storageType: String? = null,
    ): GetInstanceTypeOfferingsResult {
        val argument = GetInstanceTypeOfferingsPlainArgs(
            engineType = engineType,
            hostInstanceType = hostInstanceType,
            storageType = storageType,
        )
        return getInstanceTypeOfferingsResultToKotlin(getInstanceTypeOfferingsPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstanceTypeOfferings].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;mq&#46;kotlin&#46;inputs&#46;GetInstanceTypeOfferingsPlainArgs].
     * @return A collection of values returned by getInstanceTypeOfferings.
     */
    public suspend
    fun getInstanceTypeOfferings(argument: suspend GetInstanceTypeOfferingsPlainArgsBuilder.() -> Unit):
        GetInstanceTypeOfferingsResult {
        val builder = GetInstanceTypeOfferingsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstanceTypeOfferingsResultToKotlin(getInstanceTypeOfferingsPlain(builtArgument.toJava()).await())
    }
}
