@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mq.kotlin.inputs

import com.pulumi.aws.mq.inputs.BrokerConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property id The Configuration ID.
 * @property revision Revision of the Configuration.
 */
public data class BrokerConfigurationArgs(
    public val id: Output<String>? = null,
    public val revision: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.mq.inputs.BrokerConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.mq.inputs.BrokerConfigurationArgs =
        com.pulumi.aws.mq.inputs.BrokerConfigurationArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .revision(revision?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BrokerConfigurationArgs].
 */
@PulumiTagMarker
public class BrokerConfigurationArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var revision: Output<Int>? = null

    /**
     * @param value The Configuration ID.
     */
    @JvmName("wikhoobxamoduixl")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Revision of the Configuration.
     */
    @JvmName("ffjoffimtbnwwuen")
    public suspend fun revision(`value`: Output<Int>) {
        this.revision = value
    }

    /**
     * @param value The Configuration ID.
     */
    @JvmName("bacivrcbvqplhalh")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Revision of the Configuration.
     */
    @JvmName("rxmvxvaybvvmivjm")
    public suspend fun revision(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.revision = mapped
    }

    internal fun build(): BrokerConfigurationArgs = BrokerConfigurationArgs(
        id = id,
        revision = revision,
    )
}
