@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mq.kotlin.inputs

import com.pulumi.aws.mq.inputs.BrokerLdapServerMetadataArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property hosts List of a fully qualified domain name of the LDAP server and an optional failover server.
 * @property roleBase Fully qualified name of the directory to search for a user’s groups.
 * @property roleName Specifies the LDAP attribute that identifies the group name attribute in the object returned from the group membership query.
 * @property roleSearchMatching Search criteria for groups.
 * @property roleSearchSubtree Whether the directory search scope is the entire sub-tree.
 * @property serviceAccountPassword Service account password.
 * @property serviceAccountUsername Service account username.
 * @property userBase Fully qualified name of the directory where you want to search for users.
 * @property userRoleName Specifies the name of the LDAP attribute for the user group membership.
 * @property userSearchMatching Search criteria for users.
 * @property userSearchSubtree Whether the directory search scope is the entire sub-tree.
 */
public data class BrokerLdapServerMetadataArgs(
    public val hosts: Output<List<String>>? = null,
    public val roleBase: Output<String>? = null,
    public val roleName: Output<String>? = null,
    public val roleSearchMatching: Output<String>? = null,
    public val roleSearchSubtree: Output<Boolean>? = null,
    public val serviceAccountPassword: Output<String>? = null,
    public val serviceAccountUsername: Output<String>? = null,
    public val userBase: Output<String>? = null,
    public val userRoleName: Output<String>? = null,
    public val userSearchMatching: Output<String>? = null,
    public val userSearchSubtree: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.mq.inputs.BrokerLdapServerMetadataArgs> {
    override fun toJava(): com.pulumi.aws.mq.inputs.BrokerLdapServerMetadataArgs =
        com.pulumi.aws.mq.inputs.BrokerLdapServerMetadataArgs.builder()
            .hosts(hosts?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .roleBase(roleBase?.applyValue({ args0 -> args0 }))
            .roleName(roleName?.applyValue({ args0 -> args0 }))
            .roleSearchMatching(roleSearchMatching?.applyValue({ args0 -> args0 }))
            .roleSearchSubtree(roleSearchSubtree?.applyValue({ args0 -> args0 }))
            .serviceAccountPassword(serviceAccountPassword?.applyValue({ args0 -> args0 }))
            .serviceAccountUsername(serviceAccountUsername?.applyValue({ args0 -> args0 }))
            .userBase(userBase?.applyValue({ args0 -> args0 }))
            .userRoleName(userRoleName?.applyValue({ args0 -> args0 }))
            .userSearchMatching(userSearchMatching?.applyValue({ args0 -> args0 }))
            .userSearchSubtree(userSearchSubtree?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BrokerLdapServerMetadataArgs].
 */
@PulumiTagMarker
public class BrokerLdapServerMetadataArgsBuilder internal constructor() {
    private var hosts: Output<List<String>>? = null

    private var roleBase: Output<String>? = null

    private var roleName: Output<String>? = null

    private var roleSearchMatching: Output<String>? = null

    private var roleSearchSubtree: Output<Boolean>? = null

    private var serviceAccountPassword: Output<String>? = null

    private var serviceAccountUsername: Output<String>? = null

    private var userBase: Output<String>? = null

    private var userRoleName: Output<String>? = null

    private var userSearchMatching: Output<String>? = null

    private var userSearchSubtree: Output<Boolean>? = null

    /**
     * @param value List of a fully qualified domain name of the LDAP server and an optional failover server.
     */
    @JvmName("hiwlmjssifbcagla")
    public suspend fun hosts(`value`: Output<List<String>>) {
        this.hosts = value
    }

    @JvmName("fapwfvuipcxwtjnk")
    public suspend fun hosts(vararg values: Output<String>) {
        this.hosts = Output.all(values.asList())
    }

    /**
     * @param values List of a fully qualified domain name of the LDAP server and an optional failover server.
     */
    @JvmName("pqyfknnvijhuwktv")
    public suspend fun hosts(values: List<Output<String>>) {
        this.hosts = Output.all(values)
    }

    /**
     * @param value Fully qualified name of the directory to search for a user’s groups.
     */
    @JvmName("vduyctyjxuprtcwe")
    public suspend fun roleBase(`value`: Output<String>) {
        this.roleBase = value
    }

    /**
     * @param value Specifies the LDAP attribute that identifies the group name attribute in the object returned from the group membership query.
     */
    @JvmName("orfeirabghqxvdel")
    public suspend fun roleName(`value`: Output<String>) {
        this.roleName = value
    }

    /**
     * @param value Search criteria for groups.
     */
    @JvmName("kmbawafugpjqcbtq")
    public suspend fun roleSearchMatching(`value`: Output<String>) {
        this.roleSearchMatching = value
    }

    /**
     * @param value Whether the directory search scope is the entire sub-tree.
     */
    @JvmName("sfjqamubsncohynj")
    public suspend fun roleSearchSubtree(`value`: Output<Boolean>) {
        this.roleSearchSubtree = value
    }

    /**
     * @param value Service account password.
     */
    @JvmName("lqstjmhgfeimnqmy")
    public suspend fun serviceAccountPassword(`value`: Output<String>) {
        this.serviceAccountPassword = value
    }

    /**
     * @param value Service account username.
     */
    @JvmName("idnsjcntkstqisjw")
    public suspend fun serviceAccountUsername(`value`: Output<String>) {
        this.serviceAccountUsername = value
    }

    /**
     * @param value Fully qualified name of the directory where you want to search for users.
     */
    @JvmName("fkmjisghhtfghrkg")
    public suspend fun userBase(`value`: Output<String>) {
        this.userBase = value
    }

    /**
     * @param value Specifies the name of the LDAP attribute for the user group membership.
     */
    @JvmName("vdlkfabxdltkinkd")
    public suspend fun userRoleName(`value`: Output<String>) {
        this.userRoleName = value
    }

    /**
     * @param value Search criteria for users.
     */
    @JvmName("kkkkkvkrficlnset")
    public suspend fun userSearchMatching(`value`: Output<String>) {
        this.userSearchMatching = value
    }

    /**
     * @param value Whether the directory search scope is the entire sub-tree.
     */
    @JvmName("awemctrcosndkbgx")
    public suspend fun userSearchSubtree(`value`: Output<Boolean>) {
        this.userSearchSubtree = value
    }

    /**
     * @param value List of a fully qualified domain name of the LDAP server and an optional failover server.
     */
    @JvmName("slpyvgmjdjkvkpbm")
    public suspend fun hosts(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hosts = mapped
    }

    /**
     * @param values List of a fully qualified domain name of the LDAP server and an optional failover server.
     */
    @JvmName("wclemhpajrtkbqga")
    public suspend fun hosts(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hosts = mapped
    }

    /**
     * @param value Fully qualified name of the directory to search for a user’s groups.
     */
    @JvmName("fxxndmgkdjpukiil")
    public suspend fun roleBase(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleBase = mapped
    }

    /**
     * @param value Specifies the LDAP attribute that identifies the group name attribute in the object returned from the group membership query.
     */
    @JvmName("vbuijclkihnriasq")
    public suspend fun roleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleName = mapped
    }

    /**
     * @param value Search criteria for groups.
     */
    @JvmName("penmyxmfsyxmatwu")
    public suspend fun roleSearchMatching(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleSearchMatching = mapped
    }

    /**
     * @param value Whether the directory search scope is the entire sub-tree.
     */
    @JvmName("iithgjuviwcssgdu")
    public suspend fun roleSearchSubtree(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleSearchSubtree = mapped
    }

    /**
     * @param value Service account password.
     */
    @JvmName("gkyuxujfaokegroi")
    public suspend fun serviceAccountPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceAccountPassword = mapped
    }

    /**
     * @param value Service account username.
     */
    @JvmName("rrwjoeegjlvxxcbt")
    public suspend fun serviceAccountUsername(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceAccountUsername = mapped
    }

    /**
     * @param value Fully qualified name of the directory where you want to search for users.
     */
    @JvmName("ofreqcdepgxvsehw")
    public suspend fun userBase(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userBase = mapped
    }

    /**
     * @param value Specifies the name of the LDAP attribute for the user group membership.
     */
    @JvmName("icoxlorgvhbjerej")
    public suspend fun userRoleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userRoleName = mapped
    }

    /**
     * @param value Search criteria for users.
     */
    @JvmName("pwbjcylpkeekfbfa")
    public suspend fun userSearchMatching(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userSearchMatching = mapped
    }

    /**
     * @param value Whether the directory search scope is the entire sub-tree.
     */
    @JvmName("teluwatflbryusea")
    public suspend fun userSearchSubtree(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userSearchSubtree = mapped
    }

    internal fun build(): BrokerLdapServerMetadataArgs = BrokerLdapServerMetadataArgs(
        hosts = hosts,
        roleBase = roleBase,
        roleName = roleName,
        roleSearchMatching = roleSearchMatching,
        roleSearchSubtree = roleSearchSubtree,
        serviceAccountPassword = serviceAccountPassword,
        serviceAccountUsername = serviceAccountUsername,
        userBase = userBase,
        userRoleName = userRoleName,
        userSearchMatching = userSearchMatching,
        userSearchSubtree = userSearchSubtree,
    )
}
