@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mq.kotlin.inputs

import com.pulumi.aws.mq.inputs.BrokerMaintenanceWindowStartTimeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dayOfWeek Day of the week, e.g., `MONDAY`, `TUESDAY`, or `WEDNESDAY`.
 * @property timeOfDay Time, in 24-hour format, e.g., `02:00`.
 * @property timeZone Time zone in either the Country/City format or the UTC offset format, e.g., `CET`.
 */
public data class BrokerMaintenanceWindowStartTimeArgs(
    public val dayOfWeek: Output<String>,
    public val timeOfDay: Output<String>,
    public val timeZone: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.mq.inputs.BrokerMaintenanceWindowStartTimeArgs> {
    override fun toJava(): com.pulumi.aws.mq.inputs.BrokerMaintenanceWindowStartTimeArgs =
        com.pulumi.aws.mq.inputs.BrokerMaintenanceWindowStartTimeArgs.builder()
            .dayOfWeek(dayOfWeek.applyValue({ args0 -> args0 }))
            .timeOfDay(timeOfDay.applyValue({ args0 -> args0 }))
            .timeZone(timeZone.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BrokerMaintenanceWindowStartTimeArgs].
 */
@PulumiTagMarker
public class BrokerMaintenanceWindowStartTimeArgsBuilder internal constructor() {
    private var dayOfWeek: Output<String>? = null

    private var timeOfDay: Output<String>? = null

    private var timeZone: Output<String>? = null

    /**
     * @param value Day of the week, e.g., `MONDAY`, `TUESDAY`, or `WEDNESDAY`.
     */
    @JvmName("btcleryyirwggvxk")
    public suspend fun dayOfWeek(`value`: Output<String>) {
        this.dayOfWeek = value
    }

    /**
     * @param value Time, in 24-hour format, e.g., `02:00`.
     */
    @JvmName("ijokritvcqrotkqn")
    public suspend fun timeOfDay(`value`: Output<String>) {
        this.timeOfDay = value
    }

    /**
     * @param value Time zone in either the Country/City format or the UTC offset format, e.g., `CET`.
     */
    @JvmName("plivqvvcuigleser")
    public suspend fun timeZone(`value`: Output<String>) {
        this.timeZone = value
    }

    /**
     * @param value Day of the week, e.g., `MONDAY`, `TUESDAY`, or `WEDNESDAY`.
     */
    @JvmName("tenfvhictcuybixf")
    public suspend fun dayOfWeek(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dayOfWeek = mapped
    }

    /**
     * @param value Time, in 24-hour format, e.g., `02:00`.
     */
    @JvmName("uwuhepwjfhevmrlu")
    public suspend fun timeOfDay(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeOfDay = mapped
    }

    /**
     * @param value Time zone in either the Country/City format or the UTC offset format, e.g., `CET`.
     */
    @JvmName("oybplkmjorvjicfh")
    public suspend fun timeZone(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeZone = mapped
    }

    internal fun build(): BrokerMaintenanceWindowStartTimeArgs = BrokerMaintenanceWindowStartTimeArgs(
        dayOfWeek = dayOfWeek ?: throw PulumiNullFieldException("dayOfWeek"),
        timeOfDay = timeOfDay ?: throw PulumiNullFieldException("timeOfDay"),
        timeZone = timeZone ?: throw PulumiNullFieldException("timeZone"),
    )
}
