@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mq.kotlin.inputs

import com.pulumi.aws.mq.inputs.GetBrokerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getBroker.
 * @property brokerId Unique id of the mq broker.
 * @property brokerName Unique name of the mq broker.
 * @property tags
 */
public data class GetBrokerPlainArgs(
    public val brokerId: String? = null,
    public val brokerName: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.mq.inputs.GetBrokerPlainArgs> {
    override fun toJava(): com.pulumi.aws.mq.inputs.GetBrokerPlainArgs =
        com.pulumi.aws.mq.inputs.GetBrokerPlainArgs.builder()
            .brokerId(brokerId?.let({ args0 -> args0 }))
            .brokerName(brokerName?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetBrokerPlainArgs].
 */
@PulumiTagMarker
public class GetBrokerPlainArgsBuilder internal constructor() {
    private var brokerId: String? = null

    private var brokerName: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Unique id of the mq broker.
     */
    @JvmName("yiidykxmkuvecsmj")
    public suspend fun brokerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.brokerId = mapped
    }

    /**
     * @param value Unique name of the mq broker.
     */
    @JvmName("hotsutnglqecgwma")
    public suspend fun brokerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.brokerName = mapped
    }

    /**
     * @param value
     */
    @JvmName("qibrhmojoetfkyep")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("hytlpshanigsevaw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetBrokerPlainArgs = GetBrokerPlainArgs(
        brokerId = brokerId,
        brokerName = brokerName,
        tags = tags,
    )
}
