@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mq.kotlin.inputs

import com.pulumi.aws.mq.inputs.GetInstanceTypeOfferingsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInstanceTypeOfferings.
 * @property engineType Filter response by engine type.
 * @property hostInstanceType Filter response by host instance type.
 * @property storageType Filter response by storage type.
 */
public data class GetInstanceTypeOfferingsPlainArgs(
    public val engineType: String? = null,
    public val hostInstanceType: String? = null,
    public val storageType: String? = null,
) : ConvertibleToJava<com.pulumi.aws.mq.inputs.GetInstanceTypeOfferingsPlainArgs> {
    override fun toJava(): com.pulumi.aws.mq.inputs.GetInstanceTypeOfferingsPlainArgs =
        com.pulumi.aws.mq.inputs.GetInstanceTypeOfferingsPlainArgs.builder()
            .engineType(engineType?.let({ args0 -> args0 }))
            .hostInstanceType(hostInstanceType?.let({ args0 -> args0 }))
            .storageType(storageType?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInstanceTypeOfferingsPlainArgs].
 */
@PulumiTagMarker
public class GetInstanceTypeOfferingsPlainArgsBuilder internal constructor() {
    private var engineType: String? = null

    private var hostInstanceType: String? = null

    private var storageType: String? = null

    /**
     * @param value Filter response by engine type.
     */
    @JvmName("erfllxurrhbhtxmr")
    public suspend fun engineType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.engineType = mapped
    }

    /**
     * @param value Filter response by host instance type.
     */
    @JvmName("nnehduyfbdloylxf")
    public suspend fun hostInstanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.hostInstanceType = mapped
    }

    /**
     * @param value Filter response by storage type.
     */
    @JvmName("cknsswvuelmelujw")
    public suspend fun storageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.storageType = mapped
    }

    internal fun build(): GetInstanceTypeOfferingsPlainArgs = GetInstanceTypeOfferingsPlainArgs(
        engineType = engineType,
        hostInstanceType = hostInstanceType,
        storageType = storageType,
    )
}
