@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mq.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property kmsKeyId Amazon Resource Name (ARN) of Key Management Service (KMS) Customer Master Key (CMK) to use for encryption at rest. Requires setting `use_aws_owned_key` to `false`. To perform drift detection when AWS-managed CMKs or customer-managed CMKs are in use, this value must be configured.
 * @property useAwsOwnedKey Whether to enable an AWS-owned KMS CMK that is not in your account. Defaults to `true`. Setting to `false` without configuring `kms_key_id` will create an AWS-managed CMK aliased to `aws/mq` in your account.
 */
public data class BrokerEncryptionOptions(
    public val kmsKeyId: String? = null,
    public val useAwsOwnedKey: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.mq.outputs.BrokerEncryptionOptions):
            BrokerEncryptionOptions = BrokerEncryptionOptions(
            kmsKeyId = javaType.kmsKeyId().map({ args0 -> args0 }).orElse(null),
            useAwsOwnedKey = javaType.useAwsOwnedKey().map({ args0 -> args0 }).orElse(null),
        )
    }
}
