@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mq.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property consoleUrl
 * @property endpoints
 * @property ipAddress
 */
public data class BrokerInstance(
    public val consoleUrl: String? = null,
    public val endpoints: List<String>? = null,
    public val ipAddress: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.mq.outputs.BrokerInstance): BrokerInstance =
            BrokerInstance(
                consoleUrl = javaType.consoleUrl().map({ args0 -> args0 }).orElse(null),
                endpoints = javaType.endpoints().map({ args0 -> args0 }),
                ipAddress = javaType.ipAddress().map({ args0 -> args0 }).orElse(null),
            )
    }
}
