@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mq.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property consoleUrl
 * @property endpoints
 * @property ipAddress
 */
public data class GetBrokerInstance(
    public val consoleUrl: String,
    public val endpoints: List<String>,
    public val ipAddress: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.mq.outputs.GetBrokerInstance): GetBrokerInstance =
            GetBrokerInstance(
                consoleUrl = javaType.consoleUrl(),
                endpoints = javaType.endpoints().map({ args0 -> args0 }),
                ipAddress = javaType.ipAddress(),
            )
    }
}
