@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mq.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property hosts
 * @property roleBase
 * @property roleName
 * @property roleSearchMatching
 * @property roleSearchSubtree
 * @property serviceAccountPassword
 * @property serviceAccountUsername
 * @property userBase
 * @property userRoleName
 * @property userSearchMatching
 * @property userSearchSubtree
 */
public data class GetBrokerLdapServerMetadata(
    public val hosts: List<String>,
    public val roleBase: String,
    public val roleName: String,
    public val roleSearchMatching: String,
    public val roleSearchSubtree: Boolean,
    public val serviceAccountPassword: String,
    public val serviceAccountUsername: String,
    public val userBase: String,
    public val userRoleName: String,
    public val userSearchMatching: String,
    public val userSearchSubtree: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.mq.outputs.GetBrokerLdapServerMetadata):
            GetBrokerLdapServerMetadata = GetBrokerLdapServerMetadata(
            hosts = javaType.hosts().map({ args0 -> args0 }),
            roleBase = javaType.roleBase(),
            roleName = javaType.roleName(),
            roleSearchMatching = javaType.roleSearchMatching(),
            roleSearchSubtree = javaType.roleSearchSubtree(),
            serviceAccountPassword = javaType.serviceAccountPassword(),
            serviceAccountUsername = javaType.serviceAccountUsername(),
            userBase = javaType.userBase(),
            userRoleName = javaType.userRoleName(),
            userSearchMatching = javaType.userSearchMatching(),
            userSearchSubtree = javaType.userSearchSubtree(),
        )
    }
}
